/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.filter;

import java.nio.ByteBuffer;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.core.geotime.store.InternalGeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.util.FilterToCQLTool;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.adapter.AbstractAdapterPersistenceEncoding;
import org.locationtech.geowave.core.store.adapter.IndexedAdapterPersistenceEncoding;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.data.IndexedPersistenceEncoding;
import org.locationtech.geowave.core.store.data.MultiFieldPersistentDataset;
import org.locationtech.geowave.core.store.data.PersistentDataset;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.IndexImpl;
import org.locationtech.geowave.core.store.query.filter.QueryFilter;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLQueryFilter
implements QueryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQLQueryFilter.class);
    private InternalGeotoolsFeatureDataAdapter<?> adapter;
    private AdapterToIndexMapping indexMapping;
    private Filter filter;

    public CQLQueryFilter() {
    }

    public CQLQueryFilter(Filter filter, InternalGeotoolsFeatureDataAdapter<?> adapter, AdapterToIndexMapping indexMapping) {
        this.filter = FilterToCQLTool.fixDWithin(filter);
        this.adapter = adapter;
        this.indexMapping = indexMapping;
    }

    public String getTypeName() {
        return this.adapter.getTypeName();
    }

    public boolean accept(CommonIndexModel indexModel, IndexedPersistenceEncoding persistenceEncoding) {
        if (this.filter != null && indexModel != null && this.adapter != null) {
            IndexedAdapterPersistenceEncoding encoding;
            SimpleFeature feature;
            MultiFieldPersistentDataset adapterExtendedValues = new MultiFieldPersistentDataset();
            if (persistenceEncoding instanceof AbstractAdapterPersistenceEncoding) {
                ((AbstractAdapterPersistenceEncoding)persistenceEncoding).convertUnknownValues(this.adapter, indexModel);
                PersistentDataset existingExtValues = ((AbstractAdapterPersistenceEncoding)persistenceEncoding).getAdapterExtendedData();
                if (persistenceEncoding.isAsync()) {
                    return false;
                }
                if (existingExtValues != null) {
                    adapterExtendedValues.addValues(existingExtValues.getValues());
                }
            }
            if ((feature = (SimpleFeature)this.adapter.decode(encoding = new IndexedAdapterPersistenceEncoding(persistenceEncoding.getInternalAdapterId(), persistenceEncoding.getDataId(), persistenceEncoding.getInsertionPartitionKey(), persistenceEncoding.getInsertionSortKey(), persistenceEncoding.getDuplicateCount(), persistenceEncoding.getCommonData(), (PersistentDataset)new MultiFieldPersistentDataset(), (PersistentDataset)adapterExtendedValues), this.indexMapping, (Index)new IndexImpl(null, indexModel))) == null) {
                return false;
            }
            return this.filter.evaluate((Object)feature);
        }
        return true;
    }

    public byte[] toBinary() {
        byte[] mappingBytes;
        byte[] adapterBytes;
        byte[] filterBytes;
        if (this.filter == null) {
            LOGGER.warn("CQL filter is null");
            filterBytes = new byte[]{};
        } else {
            filterBytes = StringUtils.stringToBinary((String)ECQL.toCQL((Filter)this.filter));
        }
        if (this.adapter != null) {
            adapterBytes = PersistenceUtils.toBinary(this.adapter);
        } else {
            LOGGER.warn("Feature Data Adapter is null");
            adapterBytes = new byte[]{};
        }
        if (this.indexMapping != null) {
            mappingBytes = PersistenceUtils.toBinary((Persistable)this.indexMapping);
        } else {
            LOGGER.warn("Adapter to index mapping is null");
            mappingBytes = new byte[]{};
        }
        ByteBuffer buf = ByteBuffer.allocate(filterBytes.length + adapterBytes.length + mappingBytes.length + VarintUtils.unsignedIntByteLength((int)filterBytes.length) + VarintUtils.unsignedIntByteLength((int)adapterBytes.length));
        VarintUtils.writeUnsignedInt((int)filterBytes.length, (ByteBuffer)buf);
        buf.put(filterBytes);
        VarintUtils.writeUnsignedInt((int)adapterBytes.length, (ByteBuffer)buf);
        buf.put(adapterBytes);
        buf.put(mappingBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        GeometryUtils.initClassLoader();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int filterBytesLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (filterBytesLength > 0) {
            byte[] filterBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)filterBytesLength);
            String cql = StringUtils.stringFromBinary((byte[])filterBytes);
            try {
                this.filter = ECQL.toFilter((String)cql);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(cql, e);
            }
        } else {
            LOGGER.warn("CQL filter is empty bytes");
            this.filter = null;
        }
        int adapterBytesLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (adapterBytesLength > 0) {
            byte[] adapterBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)adapterBytesLength);
            try {
                this.adapter = (InternalGeotoolsFeatureDataAdapter)PersistenceUtils.fromBinary((byte[])adapterBytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to read adapter from CQL filter binary", e);
            }
        } else {
            LOGGER.warn("Feature Data Adapter is empty bytes");
            this.adapter = null;
        }
        int mappingBytesLength = buf.remaining();
        if (adapterBytesLength > 0) {
            byte[] mappingBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)mappingBytesLength);
            try {
                this.indexMapping = (AdapterToIndexMapping)PersistenceUtils.fromBinary((byte[])mappingBytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to read adapter to index mapping from CQL filter binary", e);
            }
        } else {
            LOGGER.warn("Adapter to index mapping is empty bytes");
            this.indexMapping = null;
        }
    }
}

