/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.geowave.core.geotime.store.query.aggregate.TimeRangeAggregation;
import org.locationtech.geowave.core.geotime.util.TimeDescriptors;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.query.aggregate.FieldNameParam;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.extra.Interval;

public class VectorTimeRangeAggregation
extends TimeRangeAggregation<FieldNameParam, SimpleFeature> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorTimeRangeAggregation.class);
    private FieldNameParam fieldNameParam;
    private final Map<String, TimeDescriptors> descMap = new HashMap<String, TimeDescriptors>();

    public VectorTimeRangeAggregation() {
        this(null);
    }

    public VectorTimeRangeAggregation(FieldNameParam fieldNameParam) {
        this.fieldNameParam = fieldNameParam;
    }

    @Override
    public FieldNameParam getParameters() {
        return this.fieldNameParam;
    }

    @Override
    public void setParameters(FieldNameParam fieldNameParam) {
        this.fieldNameParam = fieldNameParam;
    }

    @Override
    protected Interval getInterval(SimpleFeature entry) {
        if (this.fieldNameParam != null && !this.fieldNameParam.isEmpty()) {
            return TimeUtils.getInterval(entry, this.fieldNameParam.getFieldName());
        }
        String type = entry.getType().getName().getLocalPart();
        TimeDescriptors desc = this.descMap.get(type);
        if (desc == null) {
            desc = TimeUtils.inferTimeAttributeDescriptor(entry.getFeatureType());
            this.descMap.put(type, desc);
        }
        if (desc.getStartRange() != null && desc.getEndRange() != null) {
            Object start = entry.getAttribute(desc.getStartRange().getName());
            Object end = entry.getAttribute(desc.getStartRange().getName());
            if (start == null || end == null) {
                LOGGER.warn("start or end value is null, ignoring feature");
                return null;
            }
            return Interval.of((Instant)Instant.ofEpochMilli(TimeUtils.getTimeMillis(start)), (Instant)Instant.ofEpochMilli(TimeUtils.getTimeMillis(end)));
        }
        if (desc.getTime() != null) {
            Object time = entry.getAttribute(desc.getTime().getName());
            if (time == null) {
                LOGGER.warn("time attribute value is null, ignoring feature");
                return null;
            }
            Instant instant = Instant.ofEpochMilli(TimeUtils.getTimeMillis(time));
            return Interval.of((Instant)instant, (Instant)instant);
        }
        LOGGER.error("time field not found for type '" + entry.getFeatureType().getTypeName() + "'. Consider explicitly setting field name.");
        return null;
    }
}

