/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import org.locationtech.geowave.core.geotime.store.query.aggregate.BoundingBoxAggregation;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.query.aggregate.FieldNameParam;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class VectorBoundingBoxAggregation<T>
extends BoundingBoxAggregation<FieldNameParam, T> {
    private FieldNameParam fieldNameParam;
    private String spatialField = null;

    public VectorBoundingBoxAggregation() {
        this(null);
    }

    public VectorBoundingBoxAggregation(FieldNameParam fieldNameParam) {
        this.fieldNameParam = fieldNameParam;
    }

    @Override
    public FieldNameParam getParameters() {
        return this.fieldNameParam;
    }

    @Override
    public void setParameters(FieldNameParam fieldNameParam) {
        this.fieldNameParam = fieldNameParam;
    }

    @Override
    protected Envelope getEnvelope(DataTypeAdapter<T> adapter, T entry) {
        if (this.fieldNameParam != null && !this.fieldNameParam.isEmpty()) {
            Object o = adapter.getFieldValue(entry, this.fieldNameParam.getFieldName());
            if (o instanceof Geometry) {
                Geometry geometry = (Geometry)o;
                return geometry.getEnvelopeInternal();
            }
        } else {
            if (this.spatialField == null) {
                for (FieldDescriptor descriptor : adapter.getFieldDescriptors()) {
                    if (!Geometry.class.isAssignableFrom(descriptor.bindingClass())) continue;
                    this.spatialField = descriptor.fieldName();
                    break;
                }
            }
            if (this.spatialField != null) {
                return ((Geometry)adapter.getFieldValue(entry, this.spatialField)).getEnvelopeInternal();
            }
        }
        return null;
    }
}

