/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import java.time.Instant;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.threeten.extra.Interval;

public abstract class TimeRangeAggregation<P extends Persistable, T>
implements Aggregation<P, Interval, T> {
    protected long min = Long.MAX_VALUE;
    protected long max = Long.MIN_VALUE;

    public P getParameters() {
        return null;
    }

    public void setParameters(P parameters) {
    }

    public boolean isSet() {
        return this.min != Long.MAX_VALUE && this.max != Long.MIN_VALUE;
    }

    public Interval getResult() {
        if (!this.isSet()) {
            return null;
        }
        return Interval.of((Instant)Instant.ofEpochMilli(this.min), (Instant)Instant.ofEpochMilli(this.max));
    }

    public Interval merge(Interval result1, Interval result2) {
        if (result1 == null) {
            return result2;
        }
        if (result2 == null) {
            return result1;
        }
        long min = Math.min(result1.getStart().toEpochMilli(), result1.getEnd().toEpochMilli());
        long max = Math.max(result2.getStart().toEpochMilli(), result2.getEnd().toEpochMilli());
        return Interval.of((Instant)Instant.ofEpochMilli(min), (Instant)Instant.ofEpochMilli(max));
    }

    public byte[] resultToBinary(Interval result) {
        long start = Long.MAX_VALUE;
        long end = Long.MIN_VALUE;
        if (result != null) {
            start = result.getStart().toEpochMilli();
            end = result.getEnd().toEpochMilli();
        }
        ByteBuffer buffer = ByteBuffer.allocate(VarintUtils.timeByteLength((long)start) + VarintUtils.timeByteLength((long)end));
        VarintUtils.writeTime((long)start, (ByteBuffer)buffer);
        VarintUtils.writeTime((long)end, (ByteBuffer)buffer);
        return buffer.array();
    }

    public Interval resultFromBinary(byte[] binary) {
        ByteBuffer buffer = ByteBuffer.wrap(binary);
        long minTime = VarintUtils.readTime((ByteBuffer)buffer);
        long maxTime = VarintUtils.readTime((ByteBuffer)buffer);
        if (this.min == Long.MAX_VALUE || this.max == Long.MIN_VALUE) {
            return null;
        }
        return Interval.of((Instant)Instant.ofEpochMilli(minTime), (Instant)Instant.ofEpochMilli(maxTime));
    }

    public void clearResult() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
    }

    public void aggregate(DataTypeAdapter<T> adapter, T entry) {
        Interval env = this.getInterval(entry);
        this.aggregate(env);
    }

    protected void aggregate(Interval interval) {
        if (interval != null) {
            this.min = Math.min(this.min, interval.getStart().toEpochMilli());
            this.max = Math.max(this.max, interval.getEnd().toEpochMilli());
        }
    }

    protected abstract Interval getInterval(T var1);
}

