/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningType;
import org.locationtech.geowave.core.geotime.store.query.aggregate.SpatialBinningStrategy;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.data.CommonIndexedPersistenceEncoding;
import org.locationtech.geowave.core.store.data.PersistentDataset;
import org.locationtech.jts.geom.Geometry;

public class SpatialCommonIndexedBinningStrategy
extends SpatialBinningStrategy<CommonIndexedPersistenceEncoding> {
    public SpatialCommonIndexedBinningStrategy() {
        this(SpatialBinningType.S2, 3, true);
    }

    public SpatialCommonIndexedBinningStrategy(SpatialBinningType type, int precision, boolean useCentroidOnly) {
        this(type, precision, useCentroidOnly, "default_geom_dimension");
    }

    public SpatialCommonIndexedBinningStrategy(SpatialBinningType type, int precision, boolean useCentroidOnly, String geometryFieldName) {
        super(type, precision, useCentroidOnly, geometryFieldName);
    }

    @Override
    public Geometry getGeometry(DataTypeAdapter<CommonIndexedPersistenceEncoding> adapter, CommonIndexedPersistenceEncoding entry) {
        PersistentDataset data = entry.getCommonData();
        Object geometryValue = data.getValue(this.geometryFieldName);
        if (geometryValue instanceof Geometry) {
            return (Geometry)geometryValue;
        }
        return null;
    }

    @Override
    public byte[] toBinary() {
        byte[] fieldName = this.geometryFieldName.getBytes(StringUtils.getGeoWaveCharset());
        return ByteBuffer.allocate(8 + fieldName.length).putInt(this.getPrecision()).putInt(fieldName.length).put(fieldName).array();
    }

    @Override
    public void fromBinary(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.precision = bb.getInt();
        int fieldLen = bb.getInt();
        byte[] fieldBytes = new byte[fieldLen];
        bb.get(fieldBytes);
        this.geometryFieldName = new String(fieldBytes, StringUtils.getGeoWaveCharset());
    }
}

