/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.binning.ComplexGeometryBinningOption;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningType;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.api.BinningStrategy;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.entities.GeoWaveRow;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class SpatialBinningStrategy<T>
implements BinningStrategy {
    protected String geometryFieldName;
    protected int precision;
    protected ComplexGeometryBinningOption complexGeometryBinning;
    protected SpatialBinningType type;

    public SpatialBinningStrategy() {
    }

    public SpatialBinningStrategy(SpatialBinningType type, int precision, boolean useCentroidOnly, String geometryFieldName) {
        this.type = type;
        this.precision = precision;
        this.complexGeometryBinning = useCentroidOnly ? ComplexGeometryBinningOption.USE_CENTROID_ONLY : ComplexGeometryBinningOption.USE_FULL_GEOMETRY;
        this.geometryFieldName = geometryFieldName;
    }

    abstract Geometry getGeometry(DataTypeAdapter<T> var1, T var2);

    public int getPrecision() {
        return this.precision;
    }

    public <I> ByteArray[] getBins(DataTypeAdapter<I> adapter, I entry, GeoWaveRow ... rows) {
        Geometry geometry = this.getGeometry(adapter, entry);
        if (geometry == null) {
            return null;
        }
        if (ComplexGeometryBinningOption.USE_CENTROID_ONLY.equals((Object)this.complexGeometryBinning)) {
            Point centroid = geometry.getCentroid();
            return this.type.getSpatialBins((Geometry)centroid, this.precision);
        }
        return this.type.getSpatialBins(geometry, this.precision);
    }

    public byte[] toBinary() {
        byte[] fieldNameBytes = this.geometryFieldName == null ? new byte[]{} : StringUtils.stringToBinary((String)this.geometryFieldName);
        ByteBuffer buf = ByteBuffer.allocate(fieldNameBytes.length + VarintUtils.unsignedIntByteLength((int)fieldNameBytes.length) + VarintUtils.unsignedIntByteLength((int)this.type.ordinal()) + VarintUtils.unsignedIntByteLength((int)this.precision) + VarintUtils.unsignedIntByteLength((int)this.complexGeometryBinning.ordinal()));
        VarintUtils.writeUnsignedInt((int)this.type.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)this.precision, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)this.complexGeometryBinning.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)fieldNameBytes.length, (ByteBuffer)buf);
        buf.put(fieldNameBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.type = SpatialBinningType.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        this.precision = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        this.complexGeometryBinning = ComplexGeometryBinningOption.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        byte[] fieldNameBytes = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        if (fieldNameBytes.length > 0) {
            buf.get(fieldNameBytes);
            this.geometryFieldName = StringUtils.stringFromBinary((byte[])fieldNameBytes);
        } else {
            this.geometryFieldName = null;
        }
    }
}

