/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.aggregate.BaseOptimalVectorAggregation;
import org.locationtech.geowave.core.geotime.store.query.aggregate.CommonIndexTimeRangeAggregation;
import org.locationtech.geowave.core.geotime.store.query.aggregate.VectorTimeRangeAggregation;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.aggregate.FieldNameParam;
import org.threeten.extra.Interval;

public class OptimalVectorTimeRangeAggregation<P extends Persistable, T>
extends BaseOptimalVectorAggregation<P, Interval, T> {
    public OptimalVectorTimeRangeAggregation() {
    }

    public OptimalVectorTimeRangeAggregation(FieldNameParam fieldNameParam) {
        super(fieldNameParam);
    }

    @Override
    protected boolean isCommonIndex(Index index, GeotoolsFeatureDataAdapter adapter) {
        return (this.fieldNameParam == null || adapter.getTimeDescriptors().getTime() != null && this.fieldNameParam.getFieldName().equals(adapter.getTimeDescriptors().getTime().getLocalName())) && IndexOptimizationUtils.hasTime(index, adapter);
    }

    @Override
    protected Aggregation<P, Interval, T> createCommonIndexAggregation() {
        return new CommonIndexTimeRangeAggregation();
    }

    @Override
    protected Aggregation<P, Interval, T> createAggregation() {
        return new VectorTimeRangeAggregation(this.fieldNameParam);
    }
}

