/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.aggregate.BaseOptimalVectorAggregation;
import org.locationtech.geowave.core.geotime.store.query.aggregate.CommonIndexBoundingBoxAggregation;
import org.locationtech.geowave.core.geotime.store.query.aggregate.VectorBoundingBoxAggregation;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.aggregate.FieldNameParam;
import org.locationtech.jts.geom.Envelope;

public class OptimalVectorBoundingBoxAggregation<P extends Persistable, T>
extends BaseOptimalVectorAggregation<P, Envelope, T> {
    public OptimalVectorBoundingBoxAggregation() {
    }

    public OptimalVectorBoundingBoxAggregation(FieldNameParam fieldNameParam) {
        super(fieldNameParam);
    }

    @Override
    protected boolean isCommonIndex(Index index, GeotoolsFeatureDataAdapter adapter) {
        return this.fieldNameParam.getFieldName().equals(adapter.getFeatureType().getGeometryDescriptor().getLocalName()) && IndexOptimizationUtils.hasAtLeastSpatial(index);
    }

    @Override
    protected Aggregation<P, Envelope, T> createCommonIndexAggregation() {
        return new CommonIndexBoundingBoxAggregation();
    }

    @Override
    protected Aggregation<P, Envelope, T> createAggregation() {
        return new VectorBoundingBoxAggregation(this.fieldNameParam);
    }
}

