/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.store.api.Aggregation;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.jts.geom.Envelope;

public abstract class BoundingBoxAggregation<P extends Persistable, T>
implements Aggregation<P, Envelope, T> {
    protected double minX = Double.MAX_VALUE;
    protected double minY = Double.MAX_VALUE;
    protected double maxX = -1.7976931348623157E308;
    protected double maxY = -1.7976931348623157E308;

    public P getParameters() {
        return null;
    }

    public void setParameters(P parameters) {
    }

    public boolean isSet() {
        return !(this.minX > this.maxX) && !(this.minY > this.maxY);
    }

    public Envelope getResult() {
        if (!this.isSet()) {
            return new Envelope();
        }
        return new Envelope(this.minX, this.maxX, this.minY, this.maxY);
    }

    public Envelope merge(Envelope result1, Envelope result2) {
        if (result1.isNull()) {
            return result2;
        }
        if (result2.isNull()) {
            return result1;
        }
        double minX = Math.min(result1.getMinX(), result2.getMinX());
        double minY = Math.min(result1.getMinY(), result2.getMinY());
        double maxX = Math.max(result1.getMaxX(), result2.getMaxX());
        double maxY = Math.max(result1.getMaxY(), result2.getMaxY());
        return new Envelope(minX, maxX, minY, maxY);
    }

    public byte[] resultToBinary(Envelope result) {
        ByteBuffer buffer = ByteBuffer.allocate(32);
        buffer.putDouble(this.minX);
        buffer.putDouble(this.minY);
        buffer.putDouble(this.maxX);
        buffer.putDouble(this.maxY);
        return buffer.array();
    }

    public Envelope resultFromBinary(byte[] binary) {
        ByteBuffer buffer = ByteBuffer.wrap(binary);
        double minX = buffer.getDouble();
        double minY = buffer.getDouble();
        double maxX = buffer.getDouble();
        double maxY = buffer.getDouble();
        if (minX > maxX || minY > maxY) {
            return new Envelope();
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    public void clearResult() {
        this.minX = Double.MAX_VALUE;
        this.minY = Double.MAX_VALUE;
        this.maxX = -1.7976931348623157E308;
        this.maxY = -1.7976931348623157E308;
    }

    public void aggregate(DataTypeAdapter<T> adapter, T entry) {
        Envelope env = this.getEnvelope(adapter, entry);
        this.aggregate(env);
    }

    protected void aggregate(Envelope env) {
        if (env != null && !env.isNull()) {
            this.minX = Math.min(this.minX, env.getMinX());
            this.minY = Math.min(this.minY, env.getMinY());
            this.maxX = Math.max(this.maxX, env.getMaxX());
            this.maxY = Math.max(this.maxY, env.getMaxY());
        }
    }

    protected abstract Envelope getEnvelope(DataTypeAdapter<T> var1, T var2);
}

