/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.index.VarintUtils;

public class TemporalConstraints {
    private LinkedList<TemporalRange> constraints = new LinkedList();
    private String name;
    public static final TemporalRange FULL_RANGE = new TemporalRange(TemporalRange.START_TIME, TemporalRange.END_TIME);

    public TemporalConstraints() {
    }

    public String getName() {
        return this.name;
    }

    public void empty() {
        this.constraints.clear();
    }

    public TemporalConstraints(String name) {
        this.name = name;
    }

    public TemporalConstraints(List<TemporalRange> ranges, String name) {
        this.constraints.addAll(ranges);
        this.name = name;
    }

    public TemporalConstraints(TemporalRange range, String name) {
        this.constraints.add(range);
        this.name = name;
    }

    public void replaceWithIntersections(TemporalConstraints constraints) {
        this.constraints = TemporalConstraints.findIntersections((TemporalConstraints)this, (TemporalConstraints)constraints).constraints;
    }

    public void replaceWithMerged(TemporalConstraints constraints) {
        this.constraints = TemporalConstraints.merge((TemporalConstraints)this, (TemporalConstraints)constraints).constraints;
    }

    public void add(TemporalRange range) {
        TemporalRange aRange;
        int pos = 0;
        TemporalRange nextNeighbor = null;
        Iterator iterator = this.constraints.iterator();
        while (iterator.hasNext() && !(nextNeighbor = (aRange = (TemporalRange)iterator.next())).getStartTime().after(range.getStartTime())) {
            if (nextNeighbor.getEndTime().after(range.getStartTime()) || nextNeighbor.getEndTime().equals(range.getStartTime())) {
                if (range.getEndTime().before(nextNeighbor.getEndTime())) {
                    return;
                }
                this.constraints.set(pos, new TemporalRange(nextNeighbor.getStartTime(), range.getEndTime()));
                return;
            }
            ++pos;
        }
        if (nextNeighbor != null && nextNeighbor.getStartTime().before(range.getEndTime())) {
            this.constraints.add(pos, new TemporalRange(range.getStartTime(), TemporalConstraints.max(nextNeighbor.getEndTime(), range.getEndTime())));
        } else {
            this.constraints.add(pos, range);
        }
    }

    public static final Date max(Date one, Date two) {
        return one.before(two) ? two : one;
    }

    public static final Date min(Date one, Date two) {
        return one.before(two) ? one : two;
    }

    public Date getMinOr(Date min, int exclusivityIncrement) {
        return this.constraints.isEmpty() ? min : (exclusivityIncrement == 0 ? this.constraints.getFirst().getStartTime() : new Date(this.constraints.getFirst().getStartTime().getTime() + (long)exclusivityIncrement));
    }

    public Date getMaxOr(Date max, int exclusivityIncrement) {
        return this.constraints.isEmpty() ? max : (exclusivityIncrement == 0 ? this.constraints.getLast().getEndTime() : new Date(this.constraints.getLast().getEndTime().getTime() + (long)exclusivityIncrement));
    }

    public boolean isEmpty() {
        return this.constraints.isEmpty();
    }

    public TemporalRange getEndRange() {
        return this.constraints.isEmpty() ? FULL_RANGE : this.constraints.getLast();
    }

    public TemporalRange getStartRange() {
        return this.constraints.isEmpty() ? FULL_RANGE : this.constraints.getFirst();
    }

    public List<TemporalRange> getRanges() {
        return this.constraints == null ? Collections.emptyList() : this.constraints;
    }

    public static final TemporalConstraints findIntersections(TemporalConstraints sideL, TemporalConstraints sideR) {
        if (sideL.constraints.isEmpty()) {
            return sideR;
        }
        if (sideR.constraints.isEmpty()) {
            return sideL;
        }
        TemporalConstraints newSet = new TemporalConstraints(sideL.name);
        for (TemporalRange lRange : sideL.constraints) {
            for (TemporalRange rRange : sideR.constraints) {
                if (lRange.getEndTime().before(rRange.getStartTime()) || rRange.getEndTime().before(lRange.getStartTime())) continue;
                newSet.add(new TemporalRange(TemporalConstraints.max(lRange.getStartTime(), rRange.getStartTime()), TemporalConstraints.min(lRange.getEndTime(), rRange.getEndTime())));
            }
        }
        return newSet;
    }

    public static final TemporalConstraints merge(TemporalConstraints left, TemporalConstraints right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        TemporalConstraints newSetOfRanges = new TemporalConstraints(left.name);
        newSetOfRanges.constraints.addAll(left.constraints);
        for (TemporalRange range : right.constraints) {
            newSetOfRanges.add(range);
        }
        return newSetOfRanges;
    }

    public byte[] toBinary() {
        int bufferSize = VarintUtils.unsignedIntByteLength((int)this.constraints.size());
        for (TemporalRange range : this.constraints) {
            bufferSize += range.getBufferSize();
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        VarintUtils.writeUnsignedInt((int)this.constraints.size(), (ByteBuffer)buffer);
        for (TemporalRange range : this.constraints) {
            range.toBinary(buffer);
        }
        return buffer.array();
    }

    public void fromBinary(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int s = VarintUtils.readUnsignedInt((ByteBuffer)buffer);
        for (int i = 0; i < s; ++i) {
            TemporalRange range = new TemporalRange();
            range.fromBinary(buffer);
            this.add(range);
        }
    }

    public String toString() {
        return "TemporalConstraints [constraints=" + this.constraints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemporalConstraints other = (TemporalConstraints)obj;
        return !(this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints));
    }
}

