/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ScaledTemporalRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static long MILLIS_PER_DAY = 86400000L;
    private static long DEFAULT_TIME_RANGE = 365L * MILLIS_PER_DAY;
    private Date startTime = null;
    private Date endTime = null;
    private double minVal = 0.0;
    private double maxVal = 180.0;
    private long timeRange = DEFAULT_TIME_RANGE;
    private double timeScale;
    private final Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    public ScaledTemporalRange() {
        this.updateTimeScale();
    }

    public void setTimeRange(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.updateTimeScale();
    }

    public void setTimeRange(long millis) {
        this.timeRange = millis;
        this.startTime = null;
        this.endTime = null;
        this.updateTimeScale();
    }

    public void setValueRange(double minVal, double maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.updateTimeScale();
    }

    public void setTimeScale(double timeScale) {
        this.timeScale = timeScale;
    }

    private void updateTimeScale() {
        this.timeScale = (this.maxVal - this.minVal) / (double)this.getTimeRangeMillis();
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public long getTimeRangeMillis() {
        if (this.startTime == null || this.endTime == null) {
            return this.timeRange;
        }
        return this.endTime.getTime() - this.startTime.getTime();
    }

    public double timeToValue(Date time) {
        long deltaTime = time.getTime() - this.getTimeMin();
        return this.minVal + (double)deltaTime * this.timeScale;
    }

    public Date valueToTime(double timeVal) {
        long timeMillis = (long)(timeVal / this.timeScale) + this.getTimeMin();
        this.cal.setTimeInMillis(timeMillis);
        return this.cal.getTime();
    }

    private long getTimeMin() {
        if (this.startTime != null) {
            return this.startTime.getTime();
        }
        return 0L;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }
}

