/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.ArrayList;
import java.util.Collection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.core.geotime.store.InternalGeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.ExplicitCQLQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.ExplicitTemporalQuery;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraintsSet;
import org.locationtech.geowave.core.geotime.store.query.filter.SpatialQueryFilter;
import org.locationtech.geowave.core.geotime.util.ExtractAttributesFilter;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitor;
import org.locationtech.geowave.core.geotime.util.ExtractGeometryFilterVisitorResult;
import org.locationtech.geowave.core.geotime.util.ExtractTimeFilterVisitor;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.geotime.util.TimeDescriptors;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.constraints.AdapterAndIndexBasedQueryConstraints;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.filter.BasicQueryFilter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimalCQLQuery
implements AdapterAndIndexBasedQueryConstraints,
QueryConstraints {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimalCQLQuery.class);
    private Filter filter;

    public static QueryConstraints createOptimalQuery(String cql, InternalGeotoolsFeatureDataAdapter<?> adapter, Index index, AdapterToIndexMapping indexMapping) throws CQLException {
        return OptimalCQLQuery.createOptimalQuery(cql, adapter, index, indexMapping, null);
    }

    public static QueryConstraints createOptimalQuery(String cql, InternalGeotoolsFeatureDataAdapter<?> adapter, Index index, AdapterToIndexMapping indexMapping, BasicQueryByClass baseQuery) throws CQLException {
        return OptimalCQLQuery.createOptimalQuery(cql, adapter, SpatialQueryFilter.CompareOperation.INTERSECTS, index, indexMapping, baseQuery);
    }

    public static QueryConstraints createOptimalQuery(String cql, InternalGeotoolsFeatureDataAdapter<?> adapter, SpatialQueryFilter.CompareOperation geoCompareOp, Index index, AdapterToIndexMapping indexMapping, BasicQueryByClass baseQuery) throws CQLException {
        Filter cqlFilter = ECQL.toFilter((String)cql);
        return OptimalCQLQuery.createOptimalQuery(cqlFilter, adapter, geoCompareOp, index, indexMapping, baseQuery);
    }

    public static QueryConstraints createOptimalQuery(Filter cqlFilter, InternalGeotoolsFeatureDataAdapter<?> adapter, Index index, AdapterToIndexMapping indexMapping) {
        return OptimalCQLQuery.createOptimalQuery(cqlFilter, adapter, index, indexMapping, null);
    }

    public static QueryConstraints createOptimalQuery(Filter cqlFilter, InternalGeotoolsFeatureDataAdapter<?> adapter, Index index, AdapterToIndexMapping indexMapping, BasicQueryByClass baseQuery) {
        return OptimalCQLQuery.createOptimalQuery(cqlFilter, adapter, SpatialQueryFilter.CompareOperation.INTERSECTS, index, indexMapping, baseQuery);
    }

    public static QueryConstraints createOptimalQuery(Filter cqlFilter, InternalGeotoolsFeatureDataAdapter<?> adapter, SpatialQueryFilter.CompareOperation geoCompareOp, Index index, AdapterToIndexMapping indexMapping, BasicQueryByClass baseQuery) {
        TimeDescriptors timeDescriptors;
        ExtractAttributesFilter attributesVisitor = new ExtractAttributesFilter();
        Object obj = cqlFilter.accept((FilterVisitor)attributesVisitor, null);
        Collection attrs = obj != null && obj instanceof Collection ? (Collection)obj : new ArrayList();
        boolean isSpatial = IndexOptimizationUtils.hasAtLeastSpatial(index);
        boolean isTemporal = IndexOptimizationUtils.hasTime(index, adapter);
        if (isSpatial) {
            String geomName = adapter.getFeatureType().getGeometryDescriptor().getLocalName();
            attrs.remove(geomName);
        }
        if (isTemporal && (timeDescriptors = adapter.getTimeDescriptors()) != null) {
            AttributeDescriptor endDesc;
            AttributeDescriptor startDesc;
            AttributeDescriptor timeDesc = timeDescriptors.getTime();
            if (timeDesc != null) {
                attrs.remove(timeDesc.getLocalName());
            }
            if ((startDesc = timeDescriptors.getStartRange()) != null) {
                attrs.remove(startDesc.getLocalName());
            }
            if ((endDesc = timeDescriptors.getEndRange()) != null) {
                attrs.remove(endDesc.getLocalName());
            }
        }
        if (baseQuery == null) {
            CoordinateReferenceSystem indexCRS = GeometryUtils.getIndexCrs(index);
            ExtractGeometryFilterVisitorResult geometryAndCompareOp = ExtractGeometryFilterVisitor.getConstraints(cqlFilter, indexCRS, adapter.getFeatureType().getGeometryDescriptor().getLocalName());
            TemporalConstraintsSet timeConstraintSet = new ExtractTimeFilterVisitor(adapter.getTimeDescriptors()).getConstraints(cqlFilter);
            if (geometryAndCompareOp != null) {
                Geometry geometry = geometryAndCompareOp.getGeometry();
                GeometryUtils.GeoConstraintsWrapper geoConstraints = GeometryUtils.basicGeoConstraintsWrapperFromGeometry(geometry);
                BasicQueryByClass.ConstraintsByClass constraints = geoConstraints.getConstraints();
                SpatialQueryFilter.CompareOperation extractedCompareOp = geometryAndCompareOp.getCompareOp();
                if (timeConstraintSet != null && !timeConstraintSet.isEmpty()) {
                    TemporalConstraints temporalConstraints = TimeUtils.getTemporalConstraintsForDescriptors(adapter.getTimeDescriptors(), timeConstraintSet);
                    BasicQueryByClass.ConstraintsByClass timeConstraints = ExplicitSpatialTemporalQuery.createConstraints(temporalConstraints, false);
                    constraints = geoConstraints.getConstraints().merge(timeConstraints);
                }
                baseQuery = GeometryUtils.getDefaultCRS().equals(indexCRS) ? new ExplicitSpatialQuery(constraints, geometry, extractedCompareOp) : new ExplicitSpatialQuery(constraints, geometry, GeometryUtils.getCrsCode(indexCRS), extractedCompareOp, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
                if (extractedCompareOp == null) {
                    baseQuery.setExact(false);
                }
            } else if (timeConstraintSet != null && !timeConstraintSet.isEmpty()) {
                TemporalConstraints temporalConstraints = TimeUtils.getTemporalConstraintsForDescriptors(adapter.getTimeDescriptors(), timeConstraintSet);
                baseQuery = new ExplicitTemporalQuery(temporalConstraints);
            }
        }
        if (attrs.isEmpty() && baseQuery != null && baseQuery.isExact()) {
            return baseQuery;
        }
        return new ExplicitCQLQuery((QueryConstraints)baseQuery, cqlFilter, adapter, indexMapping);
    }

    public OptimalCQLQuery() {
    }

    public OptimalCQLQuery(Filter filter) {
        this.filter = filter;
    }

    public QueryConstraints createQueryConstraints(InternalDataAdapter<?> adapter, Index index, AdapterToIndexMapping indexMapping) {
        InternalGeotoolsFeatureDataAdapter gtAdapter = IndexOptimizationUtils.unwrapGeotoolsFeatureDataAdapter(adapter);
        if (gtAdapter != null) {
            return OptimalCQLQuery.createOptimalQuery(this.filter, gtAdapter, index, indexMapping);
        }
        LOGGER.error("Adapter is not a geotools feature adapter.  Cannot apply CQL filter.");
        return null;
    }

    public byte[] toBinary() {
        byte[] filterBytes;
        if (this.filter == null) {
            LOGGER.warn("CQL filter is null");
            filterBytes = new byte[]{};
        } else {
            filterBytes = StringUtils.stringToBinary((String)ECQL.toCQL((Filter)this.filter));
        }
        return filterBytes;
    }

    public void fromBinary(byte[] bytes) {
        GeometryUtils.initClassLoader();
        if (bytes.length > 0) {
            String cql = StringUtils.stringFromBinary((byte[])bytes);
            try {
                this.filter = ECQL.toFilter((String)cql);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(cql, e);
            }
        } else {
            LOGGER.warn("CQL filter is empty bytes");
            this.filter = null;
        }
    }
}

