/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.util.ArrayList;
import org.locationtech.geowave.core.geotime.index.dimension.SimpleTimeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.TimeDefinition;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.threeten.extra.Interval;

public class ExplicitTemporalQuery
extends BasicQueryByClass {
    public ExplicitTemporalQuery(Interval[] intervals) {
        super(ExplicitTemporalQuery.createTemporalConstraints(intervals));
    }

    public ExplicitTemporalQuery(TemporalConstraints contraints) {
        super(ExplicitTemporalQuery.createTemporalConstraints(contraints));
    }

    public ExplicitTemporalQuery() {
    }

    private static BasicQueryByClass.ConstraintsByClass createTemporalConstraints(TemporalConstraints temporalConstraints) {
        ArrayList<BasicQueryByClass.ConstraintSet> constraints = new ArrayList<BasicQueryByClass.ConstraintSet>();
        for (TemporalRange range : temporalConstraints.getRanges()) {
            constraints.add(new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)range.getStartTime().getTime(), (double)range.getEndTime().getTime()), false), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class}));
        }
        return new BasicQueryByClass.ConstraintsByClass(constraints);
    }

    private static BasicQueryByClass.ConstraintsByClass createTemporalConstraints(Interval[] intervals) {
        ArrayList<BasicQueryByClass.ConstraintSet> constraints = new ArrayList<BasicQueryByClass.ConstraintSet>();
        for (Interval range : intervals) {
            constraints.add(new BasicQueryByClass.ConstraintSet(new BasicQueryByClass.ConstraintData((NumericData)new NumericRange((double)range.getStart().toEpochMilli(), (double)Math.max(range.getEnd().toEpochMilli() - 1L, range.getStart().toEpochMilli())), false), new Class[]{TimeDefinition.class, SimpleTimeDefinition.class}));
        }
        return new BasicQueryByClass.ConstraintsByClass(constraints);
    }
}

