/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCrsIndexModel;
import org.locationtech.geowave.core.geotime.store.query.filter.SpatialQueryFilter;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.TWKBReader;
import org.locationtech.geowave.core.geotime.util.TWKBWriter;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.numeric.MultiDimensionalNumericData;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.query.constraints.BasicQueryByClass;
import org.locationtech.geowave.core.store.query.filter.BasicQueryFilter;
import org.locationtech.geowave.core.store.query.filter.QueryFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitSpatialQuery
extends BasicQueryByClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplicitSpatialQuery.class);
    private Geometry queryGeometry;
    private String crsCode;
    private SpatialQueryFilter.CompareOperation compareOp = SpatialQueryFilter.CompareOperation.INTERSECTS;
    private BasicQueryFilter.BasicQueryCompareOperation nonSpatialCompareOp = BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS;
    private final Map<String, CrsCache> crsCodeCache = new HashMap<String, CrsCache>();
    private CoordinateReferenceSystem crs;

    public ExplicitSpatialQuery(Geometry queryGeometry) {
        this(GeometryUtils.basicConstraintsFromGeometry(queryGeometry), queryGeometry);
    }

    public ExplicitSpatialQuery(BasicQueryByClass.ConstraintsByClass constraints, Geometry queryGeometry) {
        this(constraints, queryGeometry, (String)null);
    }

    public ExplicitSpatialQuery(BasicQueryByClass.ConstraintsByClass constraints, Geometry queryGeometry, String crsCode) {
        this(constraints, queryGeometry, crsCode, SpatialQueryFilter.CompareOperation.INTERSECTS, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
    }

    public ExplicitSpatialQuery(Geometry queryGeometry, String crsCode) {
        this(GeometryUtils.basicConstraintsFromGeometry(queryGeometry), queryGeometry, crsCode, SpatialQueryFilter.CompareOperation.INTERSECTS, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
    }

    public ExplicitSpatialQuery(Geometry queryGeometry, SpatialQueryFilter.CompareOperation compareOp) {
        this(GeometryUtils.basicConstraintsFromGeometry(queryGeometry), queryGeometry, compareOp);
    }

    public ExplicitSpatialQuery(BasicQueryByClass.ConstraintsByClass constraints, Geometry queryGeometry, SpatialQueryFilter.CompareOperation compareOp) {
        this(constraints, queryGeometry, compareOp, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
    }

    public ExplicitSpatialQuery(Geometry queryGeometry, String crsCode, SpatialQueryFilter.CompareOperation compareOp) {
        this(GeometryUtils.basicConstraintsFromGeometry(queryGeometry), queryGeometry, crsCode, compareOp == null ? SpatialQueryFilter.CompareOperation.INTERSECTS : compareOp, BasicQueryFilter.BasicQueryCompareOperation.INTERSECTS);
    }

    public ExplicitSpatialQuery(BasicQueryByClass.ConstraintsByClass constraints, Geometry queryGeometry, SpatialQueryFilter.CompareOperation compareOp, BasicQueryFilter.BasicQueryCompareOperation nonSpatialCompareOp) {
        this(constraints, queryGeometry, null, compareOp == null ? SpatialQueryFilter.CompareOperation.INTERSECTS : compareOp, nonSpatialCompareOp);
    }

    public ExplicitSpatialQuery(BasicQueryByClass.ConstraintsByClass constraints, Geometry queryGeometry, String crsCode, SpatialQueryFilter.CompareOperation compareOp, BasicQueryFilter.BasicQueryCompareOperation nonSpatialCompareOp) {
        super(constraints, nonSpatialCompareOp);
        this.crsCode = crsCode;
        this.queryGeometry = queryGeometry;
        this.compareOp = compareOp;
        this.nonSpatialCompareOp = nonSpatialCompareOp;
    }

    public ExplicitSpatialQuery() {
    }

    public Geometry getQueryGeometry() {
        return this.queryGeometry;
    }

    public String getCrsCode() {
        return this.crsCode;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    protected QueryFilter createQueryFilter(MultiDimensionalNumericData constraints, NumericDimensionField<?>[] orderedConstrainedDimensionFields, NumericDimensionField<?>[] unconstrainedDimensionDefinitions, Index index) {
        return new SpatialQueryFilter(constraints, orderedConstrainedDimensionFields, unconstrainedDimensionDefinitions, this.internalGetGeometry(index), this.compareOp, this.nonSpatialCompareOp);
    }

    protected Geometry internalGetGeometry(Index index) {
        String indexCrsStr = ExplicitSpatialQuery.getCrs(index.getIndexModel());
        CrsCache cache = this.crsCodeCache.get(indexCrsStr);
        if (cache != null) {
            return cache.geometry;
        }
        cache = this.transformToIndex(indexCrsStr, index);
        this.crsCodeCache.put(indexCrsStr, cache);
        return cache.geometry;
    }

    public List<MultiDimensionalNumericData> getIndexConstraints(Index index) {
        String indexCrsStr = ExplicitSpatialQuery.getCrs(index.getIndexModel());
        CrsCache cache = this.crsCodeCache.get(indexCrsStr);
        if (cache != null) {
            List<MultiDimensionalNumericData> indexConstraints = cache.constraintsPerIndexId.get(index.getName());
            if (indexConstraints == null) {
                indexConstraints = GeometryUtils.crsMatches(this.crsCode, indexCrsStr) || this.queryGeometry == null ? super.getIndexConstraints(index) : ExplicitSpatialQuery.indexConstraintsFromGeometry(cache.geometry, index);
                cache.constraintsPerIndexId.put(index.getName(), indexConstraints);
            }
            return indexConstraints;
        }
        cache = this.transformToIndex(indexCrsStr, index);
        this.crsCodeCache.put(indexCrsStr, cache);
        return cache.constraintsPerIndexId.get(index.getName());
    }

    private CrsCache transformToIndex(String indexCrsStr, Index index) {
        if (GeometryUtils.crsMatches(this.crsCode, indexCrsStr) || this.queryGeometry == null) {
            List constraints = super.getIndexConstraints(index);
            HashMap<String, List<MultiDimensionalNumericData>> constraintsPerIndexId = new HashMap<String, List<MultiDimensionalNumericData>>();
            constraintsPerIndexId.put(index.getName(), constraints);
            return new CrsCache(this.queryGeometry, constraintsPerIndexId);
        }
        if (this.crs == null) {
            if (this.crsCode == null || this.crsCode.isEmpty()) {
                this.crsCode = "EPSG:4326";
            }
            try {
                this.crs = CRS.decode((String)this.crsCode, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.warn("Unable to decode spatial query crs", (Throwable)e);
            }
        }
        CoordinateReferenceSystem indexCrs = GeometryUtils.isDefaultCrs(indexCrsStr) ? GeometryUtils.getDefaultCRS() : ((CustomCrsIndexModel)index.getIndexModel()).getCrs();
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)indexCrs, (boolean)true);
            Geometry indexCrsQueryGeometry = JTS.transform((Geometry)this.queryGeometry, (MathTransform)transform);
            List<MultiDimensionalNumericData> indexConstraints = ExplicitSpatialQuery.indexConstraintsFromGeometry(indexCrsQueryGeometry, index);
            HashMap<String, List<MultiDimensionalNumericData>> constraintsPerIndexId = new HashMap<String, List<MultiDimensionalNumericData>>();
            constraintsPerIndexId.put(index.getName(), indexConstraints);
            return new CrsCache(indexCrsQueryGeometry, constraintsPerIndexId);
        }
        catch (FactoryException e) {
            LOGGER.warn("Unable to create coordinate reference system transform", (Throwable)e);
        }
        catch (MismatchedDimensionException | TransformException e) {
            LOGGER.warn("Unable to transform query geometry into index CRS", e);
        }
        List constraints = super.getIndexConstraints(index);
        HashMap<String, List<MultiDimensionalNumericData>> constraintsPerIndexId = new HashMap<String, List<MultiDimensionalNumericData>>();
        constraintsPerIndexId.put(index.getName(), constraints);
        return new CrsCache(this.queryGeometry, constraintsPerIndexId);
    }

    private static List<MultiDimensionalNumericData> indexConstraintsFromGeometry(Geometry geom, Index index) {
        return GeometryUtils.basicConstraintsFromGeometry(geom).getIndexConstraints(index);
    }

    private static String getCrs(CommonIndexModel indexModel) {
        if (indexModel instanceof CustomCrsIndexModel) {
            if (GeometryUtils.isDefaultCrs(((CustomCrsIndexModel)indexModel).getCrs())) {
                return null;
            }
            return GeometryUtils.getCrsCode(((CustomCrsIndexModel)indexModel).getCrs());
        }
        return null;
    }

    public byte[] toBinary() {
        byte[] crsBinary = GeometryUtils.isDefaultCrs(this.crsCode) ? new byte[]{} : StringUtils.stringToBinary((String)this.crsCode);
        byte[] superBinary = super.toBinary();
        byte[] geometryBinary = new TWKBWriter().write(this.queryGeometry);
        ByteBuffer buf = ByteBuffer.allocate(superBinary.length + geometryBinary.length + crsBinary.length + VarintUtils.unsignedIntByteLength((int)this.compareOp.ordinal()) + VarintUtils.unsignedIntByteLength((int)this.nonSpatialCompareOp.ordinal()) + VarintUtils.unsignedIntByteLength((int)crsBinary.length) + VarintUtils.unsignedIntByteLength((int)superBinary.length));
        VarintUtils.writeUnsignedInt((int)this.compareOp.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)this.nonSpatialCompareOp.ordinal(), (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)crsBinary.length, (ByteBuffer)buf);
        VarintUtils.writeUnsignedInt((int)superBinary.length, (ByteBuffer)buf);
        buf.put(crsBinary);
        buf.put(superBinary);
        buf.put(geometryBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        this.compareOp = SpatialQueryFilter.CompareOperation.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        this.nonSpatialCompareOp = BasicQueryFilter.BasicQueryCompareOperation.values()[VarintUtils.readUnsignedInt((ByteBuffer)buf)];
        int crsBinaryLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        int superBinaryLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        byte[] crsBinary = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)crsBinaryLength);
        this.crsCode = crsBinary.length > 0 ? StringUtils.stringFromBinary((byte[])crsBinary) : null;
        byte[] superBinary = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)superBinaryLength);
        super.fromBinary(superBinary);
        try {
            this.queryGeometry = new TWKBReader().read(buf);
        }
        catch (ParseException e) {
            LOGGER.warn("Unable to read query geometry as well-known binary", (Throwable)e);
        }
    }

    private static class CrsCache {
        Geometry geometry;
        Map<String, List<MultiDimensionalNumericData>> constraintsPerIndexId;

        public CrsCache(Geometry geometry, Map<String, List<MultiDimensionalNumericData>> constraintsPerIndexId) {
            this.geometry = geometry;
            this.constraintsPerIndexId = constraintsPerIndexId;
        }
    }
}

