/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.geowave.core.geotime.store.InternalGeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.filter.CQLQueryFilter;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.numeric.MultiDimensionalNumericData;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.AdapterToIndexMapping;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.constraints.TypeConstraintQuery;
import org.locationtech.geowave.core.store.query.filter.QueryFilter;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitCQLQuery
implements QueryConstraints,
TypeConstraintQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExplicitCQLQuery.class);
    private QueryConstraints baseQuery;
    private CQLQueryFilter filter;
    private Filter cqlFilter;

    public ExplicitCQLQuery() {
    }

    public ExplicitCQLQuery(QueryConstraints baseQuery, Filter filter, InternalGeotoolsFeatureDataAdapter<?> adapter, AdapterToIndexMapping indexMapping) {
        this.baseQuery = baseQuery;
        this.cqlFilter = filter;
        this.filter = new CQLQueryFilter(filter, adapter, indexMapping);
    }

    public List<QueryFilter> createFilters(Index index) {
        ArrayList<QueryFilter> queryFilters = new ArrayList<QueryFilter>();
        if (this.filter != null) {
            queryFilters = new ArrayList<QueryFilter>(queryFilters);
            queryFilters.add(this.filter);
        }
        return queryFilters;
    }

    public List<MultiDimensionalNumericData> getIndexConstraints(Index index) {
        if (this.baseQuery != null) {
            return this.baseQuery.getIndexConstraints(index);
        }
        return Collections.emptyList();
    }

    public byte[] toBinary() {
        byte[] filterBytes;
        byte[] baseQueryBytes = this.baseQuery != null ? PersistenceUtils.toBinary((Persistable)this.baseQuery) : new byte[]{};
        if (this.filter != null) {
            filterBytes = this.filter.toBinary();
        } else {
            LOGGER.warn("Filter is null");
            filterBytes = new byte[]{};
        }
        ByteBuffer buf = ByteBuffer.allocate(filterBytes.length + baseQueryBytes.length + VarintUtils.unsignedIntByteLength((int)filterBytes.length));
        VarintUtils.writeUnsignedInt((int)filterBytes.length, (ByteBuffer)buf);
        buf.put(filterBytes);
        buf.put(baseQueryBytes);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int filterBytesLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        if (filterBytesLength > 0) {
            byte[] filterBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)filterBytesLength);
            this.filter = new CQLQueryFilter();
            this.filter.fromBinary(filterBytes);
        } else {
            LOGGER.warn("CQL filter is empty bytes");
            this.filter = null;
        }
        int baseQueryBytesLength = buf.remaining();
        if (baseQueryBytesLength > 0) {
            byte[] baseQueryBytes = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)baseQueryBytesLength);
            try {
                this.baseQuery = (QueryConstraints)PersistenceUtils.fromBinary((byte[])baseQueryBytes);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to read base query from binary", e);
            }
        } else {
            this.baseQuery = null;
        }
    }

    public String getTypeName() {
        return this.filter.getTypeName();
    }
}

