/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import java.nio.ByteBuffer;
import java.time.Instant;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.threeten.extra.Interval;

public class IntervalSerializationProvider
implements FieldSerializationProviderSpi<Interval> {
    public FieldReader<Interval> getFieldReader() {
        return new IntervalReader();
    }

    public FieldWriter<Interval> getFieldWriter() {
        return new IntervalWriter();
    }

    public static class IntervalWriter
    implements FieldWriter<Interval> {
        public byte[] writeField(Interval fieldData) {
            if (fieldData == null) {
                return new byte[0];
            }
            if (fieldData.isEmpty()) {
                long millis = fieldData.getStart().toEpochMilli();
                ByteBuffer buf = ByteBuffer.allocate(VarintUtils.timeByteLength((long)millis));
                VarintUtils.writeTime((long)millis, (ByteBuffer)buf);
                return buf.array();
            }
            long startMillis = fieldData.getStart().toEpochMilli();
            long endMillis = fieldData.getEnd().toEpochMilli();
            ByteBuffer buf = ByteBuffer.allocate(VarintUtils.timeByteLength((long)startMillis) + VarintUtils.timeByteLength((long)endMillis));
            VarintUtils.writeTime((long)startMillis, (ByteBuffer)buf);
            VarintUtils.writeTime((long)endMillis, (ByteBuffer)buf);
            return buf.array();
        }
    }

    public static class IntervalReader
    implements FieldReader<Interval> {
        public Interval readField(byte[] fieldData) {
            ByteBuffer buf = ByteBuffer.wrap(fieldData);
            Instant value = Instant.ofEpochMilli(VarintUtils.readTime((ByteBuffer)buf));
            Interval retVal = buf.hasRemaining() ? Interval.of((Instant)value, (Instant)Instant.ofEpochMilli(VarintUtils.readTime((ByteBuffer)buf))) : Interval.of((Instant)value, (Instant)value);
            return retVal;
        }
    }
}

