/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.jts.geom.Geometry;

public class GeometrySerializationProvider
implements FieldSerializationProviderSpi<Geometry> {
    private Integer geometryPrecision;

    public GeometrySerializationProvider() {
        this.geometryPrecision = GeometryUtils.MAX_GEOMETRY_PRECISION;
    }

    public GeometrySerializationProvider(@Nullable Integer geometryPrecision) {
        this.geometryPrecision = geometryPrecision;
    }

    public FieldReader<Geometry> getFieldReader() {
        return new GeometryReader(this.geometryPrecision);
    }

    public FieldWriter<Geometry> getFieldWriter() {
        return new GeometryWriter(this.geometryPrecision);
    }

    protected static class GeometryWriter
    implements FieldWriter<Geometry> {
        private Integer geometryPrecision;

        public GeometryWriter() {
            this.geometryPrecision = GeometryUtils.MAX_GEOMETRY_PRECISION;
        }

        public GeometryWriter(@Nullable Integer geometryPrecision) {
            this.geometryPrecision = geometryPrecision;
        }

        public void setPrecision(@Nullable Integer geometryPrecision) {
            this.geometryPrecision = geometryPrecision;
        }

        public byte[] writeField(Geometry fieldValue) {
            if (fieldValue == null) {
                return new byte[0];
            }
            return GeometryUtils.geometryToBinary(fieldValue, this.geometryPrecision);
        }
    }

    protected static class GeometryReader
    implements FieldReader<Geometry> {
        private Integer geometryPrecision;

        public GeometryReader() {
            this.geometryPrecision = GeometryUtils.MAX_GEOMETRY_PRECISION;
        }

        public GeometryReader(@Nullable Integer geometryPrecision) {
            this.geometryPrecision = geometryPrecision;
        }

        public void setPrecision(@Nullable Integer geometryPrecision) {
            this.geometryPrecision = geometryPrecision;
        }

        public Geometry readField(byte[] fieldData) {
            if (fieldData == null || fieldData.length < 1) {
                return null;
            }
            return GeometryUtils.geometryFromBinary(fieldData, this.geometryPrecision, (byte)1);
        }

        public Geometry readField(byte[] fieldData, byte serializationVersion) {
            if (fieldData == null || fieldData.length < 1) {
                return null;
            }
            return GeometryUtils.geometryFromBinary(fieldData, this.geometryPrecision, serializationVersion);
        }
    }
}

