/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.field.GeometrySerializationProvider;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.geowave.core.index.numeric.NumericRange;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialField
implements NumericDimensionField<Geometry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialField.class);
    public static final String DEFAULT_GEOMETRY_FIELD_NAME = "default_geom_dimension";
    public static final IndexDimensionHint LONGITUDE_DIMENSION_HINT = new IndexDimensionHint("LONGITUDE");
    public static final IndexDimensionHint LATITUDE_DIMENSION_HINT = new IndexDimensionHint("LATITUDE");
    protected NumericDimensionDefinition baseDefinition;
    private FieldReader<Geometry> geometryReader;
    private FieldWriter<Geometry> geometryWriter;
    private Integer geometryPrecision;
    private CoordinateReferenceSystem crs = GeometryUtils.getDefaultCRS();

    protected SpatialField() {
        this(null, null, null);
    }

    protected SpatialField(@Nullable Integer geometryPrecision) {
        this(null, geometryPrecision, null);
    }

    public SpatialField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision) {
        this(baseDefinition, geometryPrecision, null);
    }

    public SpatialField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision, @Nullable CoordinateReferenceSystem crs) {
        if (crs != null) {
            this.crs = crs;
        }
        this.baseDefinition = baseDefinition;
        this.geometryPrecision = geometryPrecision;
        GeometrySerializationProvider serialization = new GeometrySerializationProvider(geometryPrecision);
        this.geometryReader = serialization.getFieldReader();
        this.geometryWriter = serialization.getFieldWriter();
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public Integer getGeometryPrecision() {
        return this.geometryPrecision;
    }

    public IndexFieldMapper.IndexFieldOptions getIndexFieldOptions() {
        return new SpatialIndexFieldOptions(this.crs);
    }

    public Class<Geometry> getFieldClass() {
        return Geometry.class;
    }

    public NumericData getFullRange() {
        return this.baseDefinition.getFullRange();
    }

    public NumericRange getDenormalizedRange(BinRange range) {
        return new NumericRange(range.getNormalizedMin(), range.getNormalizedMax());
    }

    public double getRange() {
        return this.baseDefinition.getRange();
    }

    public int getFixedBinIdSize() {
        return 0;
    }

    public NumericRange getBounds() {
        return this.baseDefinition.getBounds();
    }

    public double normalize(double value) {
        return this.baseDefinition.normalize(value);
    }

    public double denormalize(double value) {
        return this.baseDefinition.denormalize(value);
    }

    public BinRange[] getNormalizedRanges(NumericData range) {
        return this.baseDefinition.getNormalizedRanges(range);
    }

    public String getFieldName() {
        return DEFAULT_GEOMETRY_FIELD_NAME;
    }

    public FieldWriter<Geometry> getWriter() {
        return this.geometryWriter;
    }

    public FieldReader<Geometry> getReader() {
        return this.geometryReader;
    }

    public NumericDimensionDefinition getBaseDefinition() {
        return this.baseDefinition;
    }

    public byte[] toBinary() {
        byte[] dimensionBinary = PersistenceUtils.toBinary((Persistable)this.baseDefinition);
        byte[] crsBinary = StringUtils.stringToBinary((String)CRS.toSRS((CoordinateReferenceSystem)this.crs));
        ByteBuffer buf = ByteBuffer.allocate(VarintUtils.unsignedShortByteLength((short)((short)dimensionBinary.length)) + dimensionBinary.length + 1 + crsBinary.length);
        VarintUtils.writeUnsignedShort((short)((short)dimensionBinary.length), (ByteBuffer)buf);
        buf.put(dimensionBinary);
        if (this.geometryPrecision == null) {
            buf.put((byte)127);
        } else {
            buf.put((byte)this.geometryPrecision.intValue());
        }
        buf.put(crsBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        byte[] dimensionBinary = new byte[VarintUtils.readUnsignedShort((ByteBuffer)buf)];
        buf.get(dimensionBinary);
        this.baseDefinition = (NumericDimensionDefinition)PersistenceUtils.fromBinary((byte[])dimensionBinary);
        byte precision = buf.get();
        this.geometryPrecision = precision == 127 ? null : Integer.valueOf(precision);
        GeometrySerializationProvider serialization = new GeometrySerializationProvider(this.geometryPrecision);
        this.geometryReader = serialization.getFieldReader();
        this.geometryWriter = serialization.getFieldWriter();
        byte[] crsBinary = new byte[buf.remaining()];
        buf.get(crsBinary);
        try {
            this.crs = CRS.decode((String)StringUtils.stringFromBinary((byte[])crsBinary), (boolean)true);
        }
        catch (FactoryException e) {
            LOGGER.warn("Unable to decode index field CRS");
            this.crs = GeometryUtils.getDefaultCRS();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String className = this.getClass().getName();
        result = 31 * result + (className == null ? 0 : className.hashCode());
        result = 31 * result + (this.baseDefinition == null ? 0 : this.baseDefinition.hashCode());
        result = 31 * result + (this.geometryPrecision == null ? 0 : this.geometryPrecision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialField other = (SpatialField)obj;
        if (this.baseDefinition == null ? other.baseDefinition != null : !this.baseDefinition.equals(other.baseDefinition)) {
            return false;
        }
        return !(this.geometryPrecision == null ? other.geometryPrecision != null : !this.geometryPrecision.equals(other.geometryPrecision));
    }

    public static class SpatialIndexFieldOptions
    implements IndexFieldMapper.IndexFieldOptions {
        private final CoordinateReferenceSystem indexCRS;

        public SpatialIndexFieldOptions(CoordinateReferenceSystem indexCRS) {
            this.indexCRS = indexCRS;
        }

        public CoordinateReferenceSystem crs() {
            return this.indexCRS;
        }
    }
}

