/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.jts.geom.Geometry;

public class LongitudeField
extends SpatialField {
    public LongitudeField() {
    }

    public LongitudeField(@Nullable Integer geometryPrecision) {
        this((NumericDimensionDefinition)new LongitudeDefinition(), geometryPrecision);
    }

    public LongitudeField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision) {
        super(baseDefinition, geometryPrecision);
    }

    public NumericData getNumericData(Geometry geometry) {
        return GeometryUtils.xRangeFromGeometry(geometry);
    }

    public Set<IndexDimensionHint> getDimensionHints() {
        return Sets.newHashSet((Object[])new IndexDimensionHint[]{SpatialField.LONGITUDE_DIMENSION_HINT});
    }
}

