/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.jts.geom.Geometry;

public class LatitudeField
extends SpatialField {
    public LatitudeField() {
    }

    public LatitudeField(@Nullable Integer geometryPrecision, boolean useHalfRange) {
        this((NumericDimensionDefinition)new LatitudeDefinition(useHalfRange), geometryPrecision);
    }

    public LatitudeField(@Nullable Integer geometryPrecision) {
        this(geometryPrecision, false);
    }

    public LatitudeField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision) {
        super(baseDefinition, geometryPrecision);
    }

    public NumericData getNumericData(Geometry geometry) {
        return GeometryUtils.yRangeFromGeometry(geometry);
    }

    public Set<IndexDimensionHint> getDimensionHints() {
        return Sets.newHashSet((Object[])new IndexDimensionHint[]{SpatialField.LATITUDE_DIMENSION_HINT});
    }
}

