/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSSpatialDimension;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.numeric.NumericData;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CustomCRSSpatialField
extends SpatialField {
    public CustomCRSSpatialField() {
    }

    public CustomCRSSpatialField(CustomCRSSpatialDimension baseDefinition, @Nullable Integer geometryPrecision, @Nullable CoordinateReferenceSystem crs) {
        super(baseDefinition, geometryPrecision, crs);
    }

    public NumericData getNumericData(Geometry geometry) {
        if (((CustomCRSSpatialDimension)this.baseDefinition).getAxis() == 0) {
            return GeometryUtils.xRangeFromGeometry(geometry);
        }
        return GeometryUtils.yRangeFromGeometry(geometry);
    }

    public Set<IndexDimensionHint> getDimensionHints() {
        if (((CustomCRSSpatialDimension)this.baseDefinition).getAxis() == 0) {
            return Sets.newHashSet((Object[])new IndexDimensionHint[]{SpatialField.LONGITUDE_DIMENSION_HINT});
        }
        return Sets.newHashSet((Object[])new IndexDimensionHint[]{SpatialField.LATITUDE_DIMENSION_HINT});
    }
}

