/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index.dimension;

import org.locationtech.geowave.core.index.FloatCompareUtils;
import org.locationtech.geowave.core.index.dimension.BasicDimensionDefinition;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.numeric.NumericData;

public class LongitudeDefinition
extends BasicDimensionDefinition {
    public LongitudeDefinition() {
        super(-180.0, 180.0);
    }

    public BinRange[] getNormalizedRanges(NumericData range) {
        if (range == null) {
            return new BinRange[0];
        }
        if (FloatCompareUtils.checkDoublesEqual((double)((Double)range.getMin()), (double)((Double)range.getMax()))) {
            return super.getNormalizedRanges(range);
        }
        double normalizedMin = LongitudeDefinition.getNormalizedLongitude((Double)range.getMin());
        double normalizedMax = LongitudeDefinition.getNormalizedLongitude((Double)range.getMax());
        if (!(!(normalizedMax < normalizedMin) || FloatCompareUtils.checkDoublesEqual((double)normalizedMax, (double)-1.0) && FloatCompareUtils.checkDoublesEqual((double)normalizedMin, (double)0.0))) {
            return new BinRange[]{new BinRange(-180.0, normalizedMax), new BinRange(normalizedMin, 180.0)};
        }
        return new BinRange[]{new BinRange(normalizedMin, normalizedMax)};
    }

    public static double getNormalizedLongitude(double lon) {
        if (lon <= 180.0 && lon >= -180.0) {
            return lon;
        }
        double offsetLon = lon + 180.0;
        return (Math.ceil(Math.abs(offsetLon) / 360.0) * 360.0 + offsetLon) % 360.0 - 180.0;
    }

    public byte[] toBinary() {
        return new byte[0];
    }

    public void fromBinary(byte[] bytes) {
    }
}

