/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.geowave.core.geotime.index.SpatialTemporalOptions;
import org.locationtech.geowave.core.geotime.index.TemporalOptions;
import org.locationtech.geowave.core.geotime.index.dimension.SimpleTimeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.SimpleTimeIndexStrategy;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.geotime.index.dimension.TimeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.index.NumericIndexStrategy;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.SFCFactory;
import org.locationtech.geowave.core.index.sfc.xz.XZHierarchicalIndexFactory;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.BasicNumericDimensionField;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.BasicIndexModel;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.CustomNameIndex;
import org.locationtech.geowave.core.store.spi.DimensionalityTypeProviderSpi;

public class TemporalDimensionalityTypeProvider
implements DimensionalityTypeProviderSpi<TemporalOptions> {
    private static final String DEFAULT_TEMPORAL_ID_STR = "TIME_IDX";
    public static final NumericDimensionDefinition[] TEMPORAL_DIMENSIONS = new NumericDimensionDefinition[]{new TimeDefinition(SpatialTemporalOptions.DEFAULT_PERIODICITY)};
    public static final NumericDimensionField<?>[] TEMPORAL_FIELDS = new NumericDimensionField[]{new TimeField(SpatialTemporalOptions.DEFAULT_PERIODICITY)};

    public String getDimensionalityTypeName() {
        return "temporal";
    }

    public String getDimensionalityTypeDescription() {
        return "This dimensionality type matches all indices that only require Time.";
    }

    public TemporalOptions createOptions() {
        return new TemporalOptions();
    }

    public Index createIndex(DataStore dataStore, TemporalOptions options) {
        return TemporalDimensionalityTypeProvider.createIndexFromOptions(options);
    }

    public static Index createIndexFromOptions(TemporalOptions options) {
        if (!options.noTimeRanges) {
            NumericDimensionDefinition[] dimensions = TEMPORAL_DIMENSIONS;
            NumericDimensionField<?>[] fields = TEMPORAL_FIELDS;
            dimensions[dimensions.length - 1] = new TimeDefinition(options.periodicity);
            fields[dimensions.length - 1] = new TimeField(options.periodicity);
            BasicIndexModel indexModel = new BasicIndexModel(fields);
            String combinedArrayID = "TIME_IDX_" + (Object)((Object)options.periodicity);
            return new CustomNameIndex((NumericIndexStrategy)XZHierarchicalIndexFactory.createFullIncrementalTieredStrategy((NumericDimensionDefinition[])dimensions, (int[])new int[]{63}, (SFCFactory.SFCType)SFCFactory.SFCType.HILBERT, (Long)options.maxDuplicates), (CommonIndexModel)indexModel, combinedArrayID);
        }
        BasicIndexModel indexModel = new BasicIndexModel(new NumericDimensionField[]{new BasicNumericDimensionField("default_time_dimension", Long.class)});
        return new CustomNameIndex((NumericIndexStrategy)new SimpleTimeIndexStrategy(), (CommonIndexModel)indexModel, DEFAULT_TEMPORAL_ID_STR);
    }

    public static boolean isTemporal(Index index) {
        if (index == null) {
            return false;
        }
        return TemporalDimensionalityTypeProvider.isTemporal(index.getIndexStrategy());
    }

    public static boolean isTemporal(NumericIndexStrategy indexStrategy) {
        if (indexStrategy == null || indexStrategy.getOrderedDimensionDefinitions() == null) {
            return false;
        }
        NumericDimensionDefinition[] dimensions = indexStrategy.getOrderedDimensionDefinitions();
        if (dimensions.length < 1) {
            return false;
        }
        for (NumericDimensionDefinition definition : dimensions) {
            if (!(definition instanceof TimeDefinition) && !(definition instanceof SimpleTimeDefinition)) continue;
            return true;
        }
        return false;
    }

    public static class UnitConverter
    implements IStringConverter<TemporalBinningStrategy.Unit> {
        public TemporalBinningStrategy.Unit convert(String value) {
            TemporalBinningStrategy.Unit convertedValue = TemporalBinningStrategy.Unit.fromString(value);
            if (convertedValue == null) {
                throw new ParameterException("Value " + value + "can not be converted to Unit. Available values are: " + StringUtils.join((Object[])TemporalBinningStrategy.Unit.values(), (String)", ").toLowerCase(Locale.ENGLISH));
            }
            return convertedValue;
        }
    }
}

