/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index;

import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.LongitudeDefinition;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimension;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSBoundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSSpatialField;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimension;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionX;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCRSUnboundedSpatialDimensionY;
import org.locationtech.geowave.core.geotime.store.dimension.CustomCrsIndexModel;
import org.locationtech.geowave.core.geotime.store.dimension.LatitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.LongitudeField;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.SpatialIndexUtils;
import org.locationtech.geowave.core.index.NumericIndexStrategy;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.SFCFactory;
import org.locationtech.geowave.core.index.sfc.xz.XZHierarchicalIndexFactory;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.BasicIndexModel;
import org.locationtech.geowave.core.store.index.CommonIndexModel;
import org.locationtech.geowave.core.store.index.CustomNameIndex;
import org.locationtech.geowave.core.store.spi.DimensionalityTypeProviderSpi;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class SpatialDimensionalityTypeProvider
implements DimensionalityTypeProviderSpi<SpatialOptions> {
    private static final String DEFAULT_SPATIAL_ID = "SPATIAL_IDX";
    public static final int LONGITUDE_BITS = 31;
    public static final int LATITUDE_BITS = 31;
    public static final double DEFAULT_UNBOUNDED_CRS_INTERVAL = 4.0075017E7;
    public static final NumericDimensionDefinition[] SPATIAL_DIMENSIONS = new NumericDimensionDefinition[]{new LongitudeDefinition(), new LatitudeDefinition(true)};

    public static NumericDimensionField[] getSpatialFields(@Nullable Integer geometryPrecision) {
        return new NumericDimensionField[]{new LongitudeField(geometryPrecision), new LatitudeField(geometryPrecision, true)};
    }

    public static NumericDimensionField[] getSpatialTemporalFields(@Nullable Integer geometryPrecision) {
        return new NumericDimensionField[]{new LongitudeField(geometryPrecision), new LatitudeField(geometryPrecision, true), new TimeField(TemporalBinningStrategy.Unit.YEAR)};
    }

    public String getDimensionalityTypeName() {
        return "spatial";
    }

    public String getDimensionalityTypeDescription() {
        return "This dimensionality type matches all indices that only require Geometry.";
    }

    public SpatialOptions createOptions() {
        return new SpatialOptions();
    }

    public Index createIndex(DataStore dataStore, SpatialOptions options) {
        return SpatialDimensionalityTypeProvider.createIndexFromOptions(options);
    }

    public static Index createIndexFromOptions(SpatialOptions options) {
        boolean isDefaultCRS;
        NumericDimensionDefinition[] dimensions;
        String crsCode = null;
        NumericDimensionField[] fields = null;
        NumericDimensionField[] fields_temporal = null;
        Integer geometryPrecision = options.getGeometryPrecision();
        if (options.crs == null || options.crs.isEmpty() || options.crs.equalsIgnoreCase("EPSG:4326")) {
            dimensions = SPATIAL_DIMENSIONS;
            fields = SpatialDimensionalityTypeProvider.getSpatialFields(geometryPrecision);
            isDefaultCRS = true;
            crsCode = "EPSG:4326";
        } else {
            CoordinateReferenceSystem crs = GeometryUtils.decodeCRS(options.crs);
            CoordinateSystem cs = crs.getCoordinateSystem();
            isDefaultCRS = false;
            crsCode = options.crs;
            dimensions = new NumericDimensionDefinition[cs.getDimension()];
            if (options.storeTime) {
                fields_temporal = new NumericDimensionField[dimensions.length + 1];
                for (int d = 0; d < dimensions.length; ++d) {
                    CoordinateSystemAxis csa = cs.getAxis(d);
                    if (!SpatialDimensionalityTypeProvider.isUnbounded(csa)) {
                        dimensions[d] = new CustomCRSBoundedSpatialDimension((byte)d, csa.getMinimumValue(), csa.getMaximumValue());
                        fields_temporal[d] = new CustomCRSSpatialField((CustomCRSBoundedSpatialDimension)dimensions[d], geometryPrecision, crs);
                        continue;
                    }
                    dimensions[d] = new CustomCRSUnboundedSpatialDimension(4.0075017E7, (byte)d);
                    fields_temporal[d] = new CustomCRSSpatialField((CustomCRSUnboundedSpatialDimension)dimensions[d], geometryPrecision, crs);
                }
                fields_temporal[dimensions.length] = new TimeField(TemporalBinningStrategy.Unit.YEAR);
            } else {
                fields = new NumericDimensionField[dimensions.length];
                for (int d = 0; d < dimensions.length; ++d) {
                    CoordinateSystemAxis csa = cs.getAxis(d);
                    if (!SpatialDimensionalityTypeProvider.isUnbounded(csa)) {
                        if (d == 0) {
                            dimensions[d] = new CustomCRSBoundedSpatialDimensionX(csa.getMinimumValue(), csa.getMaximumValue());
                            fields[d] = new CustomCRSSpatialField((CustomCRSBoundedSpatialDimensionX)dimensions[d], geometryPrecision, crs);
                        }
                        if (d != 1) continue;
                        dimensions[d] = new CustomCRSBoundedSpatialDimensionY(csa.getMinimumValue(), csa.getMaximumValue());
                        fields[d] = new CustomCRSSpatialField((CustomCRSBoundedSpatialDimensionY)dimensions[d], geometryPrecision, crs);
                        continue;
                    }
                    if (d == 0) {
                        dimensions[d] = new CustomCRSUnboundedSpatialDimensionX(4.0075017E7, (byte)d);
                        fields[d] = new CustomCRSSpatialField((CustomCRSUnboundedSpatialDimensionX)dimensions[d], geometryPrecision, crs);
                    }
                    if (d != 1) continue;
                    dimensions[d] = new CustomCRSUnboundedSpatialDimensionY(4.0075017E7, (byte)d);
                    fields[d] = new CustomCRSSpatialField((CustomCRSUnboundedSpatialDimensionY)dimensions[d], geometryPrecision, crs);
                }
            }
        }
        Object indexModel = null;
        indexModel = isDefaultCRS ? new BasicIndexModel(options.storeTime ? SpatialDimensionalityTypeProvider.getSpatialTemporalFields(geometryPrecision) : SpatialDimensionalityTypeProvider.getSpatialFields(geometryPrecision)) : new CustomCrsIndexModel(options.storeTime ? fields_temporal : fields, crsCode);
        return new CustomNameIndex((NumericIndexStrategy)XZHierarchicalIndexFactory.createFullIncrementalTieredStrategy((NumericDimensionDefinition[])dimensions, (int[])new int[]{31, 31}, (SFCFactory.SFCType)SFCFactory.SFCType.HILBERT), (CommonIndexModel)indexModel, isDefaultCRS ? (options.storeTime ? "SPATIAL_IDX_TIME" : DEFAULT_SPATIAL_ID) : (options.storeTime ? "SPATIAL_IDX_TIME" : DEFAULT_SPATIAL_ID) + "_" + crsCode.substring(crsCode.indexOf(":") + 1));
    }

    private static boolean isUnbounded(CoordinateSystemAxis csa) {
        double min = csa.getMinimumValue();
        double max = csa.getMaximumValue();
        return !Double.isFinite(max) || !Double.isFinite(min);
    }

    public static boolean isSpatial(Index index) {
        if (index == null) {
            return false;
        }
        return SpatialDimensionalityTypeProvider.isSpatial(index.getIndexStrategy());
    }

    public static boolean isSpatial(NumericIndexStrategy indexStrategy) {
        if (indexStrategy == null || indexStrategy.getOrderedDimensionDefinitions() == null) {
            return false;
        }
        NumericDimensionDefinition[] dimensions = indexStrategy.getOrderedDimensionDefinitions();
        if (dimensions.length < 2) {
            return false;
        }
        boolean hasLat = false;
        boolean hasLon = false;
        for (NumericDimensionDefinition definition : dimensions) {
            if (SpatialIndexUtils.isLatitudeDimension(definition)) {
                hasLat = true;
                continue;
            }
            if (!SpatialIndexUtils.isLongitudeDimension(definition)) continue;
            hasLon = true;
        }
        return hasLat && hasLon;
    }
}

