/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.index;

import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptor;
import org.locationtech.geowave.core.geotime.index.SpatialDimensionalityTypeProvider;
import org.locationtech.geowave.core.geotime.index.SpatialOptions;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.AttributeIndex;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.index.AttributeIndexImpl;
import org.locationtech.geowave.core.store.index.AttributeIndexProviderSpi;
import org.locationtech.jts.geom.Geometry;

public class SpatialAttributeIndexProvider
implements AttributeIndexProviderSpi {
    public boolean supportsDescriptor(FieldDescriptor<?> fieldDescriptor) {
        return Geometry.class.isAssignableFrom(fieldDescriptor.bindingClass());
    }

    public AttributeIndex buildIndex(String indexName, DataTypeAdapter<?> adapter, FieldDescriptor<?> fieldDescriptor) {
        SpatialOptions options = new SpatialOptions();
        if (fieldDescriptor instanceof SpatialFieldDescriptor) {
            options.setCrs(GeometryUtils.getCrsCode(((SpatialFieldDescriptor)fieldDescriptor).crs()));
        }
        Index index = SpatialDimensionalityTypeProvider.createIndexFromOptions(options);
        return new AttributeIndexImpl(index.getIndexStrategy(), index.getIndexModel(), indexName, fieldDescriptor.fieldName());
    }
}

