/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.binning;

import org.locationtech.geowave.core.geotime.binning.GeohashBinningHelper;
import org.locationtech.geowave.core.geotime.binning.H3BinningHelper;
import org.locationtech.geowave.core.geotime.binning.S2BinningHelper;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningHelper;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.store.api.BinConstraints;
import org.locationtech.jts.geom.Geometry;

public enum SpatialBinningType implements SpatialBinningHelper
{
    H3(new H3BinningHelper()),
    S2(new S2BinningHelper()),
    GEOHASH(new GeohashBinningHelper());

    private SpatialBinningHelper helperDelegate;

    private SpatialBinningType(SpatialBinningHelper helperDelegate) {
        this.helperDelegate = helperDelegate;
    }

    @Override
    public ByteArray[] getSpatialBins(Geometry geometry, int precision) {
        return this.helperDelegate.getSpatialBins(geometry, precision);
    }

    @Override
    public BinConstraints.ByteArrayConstraints getGeometryConstraints(Geometry geom, int precision) {
        return this.helperDelegate.getGeometryConstraints(geom, precision);
    }

    @Override
    public Geometry getBinGeometry(ByteArray bin, int precision) {
        return this.helperDelegate.getBinGeometry(bin, precision);
    }

    @Override
    public String binToString(byte[] binId) {
        return this.helperDelegate.binToString(binId);
    }

    @Override
    public int getBinByteLength(int precision) {
        return this.helperDelegate.getBinByteLength(precision);
    }

    public static SpatialBinningType fromString(String code) {
        for (SpatialBinningType output : SpatialBinningType.values()) {
            if (!output.toString().equalsIgnoreCase(code)) continue;
            return output;
        }
        return null;
    }
}

