/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.binning;

import com.google.common.collect.Streams;
import com.google.common.geometry.S2Cell;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2CellUnion;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2PolygonBuilder;
import com.google.common.geometry.S2Polyline;
import com.google.common.geometry.S2Region;
import com.google.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningHelper;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.ByteArrayRange;
import org.locationtech.geowave.core.index.lexicoder.Lexicoders;
import org.locationtech.geowave.core.index.lexicoder.LongLexicoder;
import org.locationtech.geowave.core.store.api.BinConstraints;
import org.locationtech.geowave.core.store.statistics.query.BinConstraintsImpl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class S2BinningHelper
implements SpatialBinningHelper {
    @Override
    public BinConstraints.ByteArrayConstraints getGeometryConstraints(Geometry geom, int precision) {
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMaxCells(100);
        coverer.setMaxLevel(precision);
        S2CellUnion s2CellUnion = S2BinningHelper.cellCoverage(geom, coverer);
        return new BinConstraintsImpl.ExplicitConstraints((ByteArrayRange[])Streams.stream((Iterator)s2CellUnion.iterator()).map(c -> new ByteArrayRange(Lexicoders.LONG.toByteArray(Long.valueOf(c.rangeMin().id())), Lexicoders.LONG.toByteArray(Long.valueOf(c.rangeMax().id())))).toArray(ByteArrayRange[]::new));
    }

    @Override
    public String binToString(byte[] binId) {
        Long id = Lexicoders.LONG.fromByteArray(binId);
        return new S2CellId(id.longValue()).toToken();
    }

    private static S2CellUnion cellCoverage(Geometry geom, S2RegionCoverer coverer) {
        if (geom.equalsExact(geom.getEnvelope())) {
            double minx = geom.getEnvelopeInternal().getMinX();
            double maxx = geom.getEnvelopeInternal().getMaxX();
            double miny = geom.getEnvelopeInternal().getMinY();
            double maxy = geom.getEnvelopeInternal().getMaxY();
            S2LatLngRect s2Region = new S2LatLngRect(S2LatLng.fromDegrees((double)miny, (double)minx), S2LatLng.fromDegrees((double)maxy, (double)maxx));
            return coverer.getCovering((S2Region)s2Region);
        }
        S2GeometryHandler geometryHandler = new S2GeometryHandler(coverer);
        GeometryUtils.visitGeometry(geom, geometryHandler);
        return geometryHandler.cellUnion;
    }

    @Override
    public ByteArray[] getSpatialBins(Geometry geometry, int precision) {
        if (geometry instanceof Point) {
            Point centroid = geometry.getCentroid();
            return new ByteArray[]{new ByteArray(Lexicoders.LONG.toByteArray(Long.valueOf(S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)centroid.getY(), (double)centroid.getX())).parent(precision).id())))};
        }
        return S2BinningHelper.getSpatialBinsComplexGeometry(geometry, precision);
    }

    @Override
    public Geometry getBinGeometry(ByteArray bin, int precision) {
        Long id = Lexicoders.LONG.fromByteArray(bin.getBytes());
        List<Coordinate> coords = IntStream.range(0, 4).mapToObj(i -> new S2Cell(new S2CellId(id.longValue())).getVertex(i)).map(S2LatLng::new).map(ll -> new Coordinate(ll.lngDegrees(), ll.latDegrees())).collect(Collectors.toList());
        coords.add((Coordinate)coords.get(0));
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon(coords.toArray(new Coordinate[5]));
    }

    private static ByteArray[] getSpatialBinsComplexGeometry(Geometry geometry, int precision) {
        S2RegionCoverer coverer = new S2RegionCoverer();
        coverer.setMaxCells(10000);
        coverer.setMinLevel(precision);
        coverer.setMaxLevel(precision);
        S2CellUnion cellUnion = S2BinningHelper.cellCoverage(geometry, coverer);
        ArrayList cellIds = new ArrayList();
        cellUnion.denormalize(precision, 1, cellIds);
        return (ByteArray[])cellIds.stream().map(S2CellId::id).map(arg_0 -> ((LongLexicoder)Lexicoders.LONG).toByteArray(arg_0)).map(ByteArray::new).toArray(ByteArray[]::new);
    }

    @Override
    public int getBinByteLength(int precision) {
        return 8;
    }

    private static class S2GeometryHandler
    implements GeometryUtils.GeometryHandler {
        private S2CellUnion cellUnion = new S2CellUnion();
        private final S2RegionCoverer coverer;

        public S2GeometryHandler(S2RegionCoverer coverer) {
            this.coverer = coverer;
        }

        @Override
        public void handlePoint(Point point) {
            S2CellUnion newUnion = new S2CellUnion();
            ArrayList cellIds = this.cellUnion.cellIds();
            cellIds.add(S2CellId.fromLatLng((S2LatLng)S2LatLng.fromDegrees((double)point.getY(), (double)point.getX())));
            newUnion.initFromCellIds(cellIds);
            this.cellUnion = newUnion;
        }

        @Override
        public void handleLineString(LineString lineString) {
            S2CellUnion newUnion = new S2CellUnion();
            newUnion.getUnion(this.coverer.getCovering((S2Region)new S2Polyline(Arrays.stream(lineString.getCoordinates()).map(c -> S2LatLng.fromDegrees((double)c.getY(), (double)c.getX()).toPoint()).collect(Collectors.toList()))), this.cellUnion);
            this.cellUnion = newUnion;
        }

        @Override
        public void handlePolygon(Polygon polygon) {
            polygon.normalize();
            S2PolygonBuilder bldr = new S2PolygonBuilder();
            int numInteriorRings = polygon.getNumInteriorRing();
            if (numInteriorRings > 0) {
                for (int i = 0; i < numInteriorRings; ++i) {
                    LinearRing ls = polygon.getInteriorRingN(i);
                    bldr.addLoop(new S2Loop(Arrays.stream(ls.getCoordinates()).map(c -> S2LatLng.fromDegrees((double)c.getY(), (double)c.getX()).toPoint()).collect(Collectors.toList())));
                }
            }
            bldr.addLoop(new S2Loop(Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(c -> S2LatLng.fromDegrees((double)c.getY(), (double)c.getX()).toPoint()).collect(Collectors.toList())));
            S2CellUnion newUnion = new S2CellUnion();
            newUnion.getUnion(this.coverer.getCovering((S2Region)bldr.assemblePolygon()), this.cellUnion);
            this.cellUnion = newUnion;
        }
    }
}

