/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.binning;

import com.uber.h3core.H3Core;
import com.uber.h3core.LengthUnit;
import com.uber.h3core.exceptions.LineUndefinedException;
import com.uber.h3core.util.GeoCoord;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningHelper;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.lexicoder.Lexicoders;
import org.locationtech.geowave.core.index.lexicoder.LongLexicoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class H3BinningHelper
implements SpatialBinningHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(H3BinningHelper.class);
    private static final Object H3_MUTEX = new Object();
    private static H3Core h3Core;

    H3BinningHelper() {
    }

    @Override
    public ByteArray[] getSpatialBins(Geometry geometry, int precision) {
        H3GeometryHandler h3Handler = new H3GeometryHandler(precision);
        GeometryUtils.visitGeometry(geometry, h3Handler);
        return (ByteArray[])h3Handler.ids.stream().map(arg_0 -> ((LongLexicoder)Lexicoders.LONG).toByteArray(arg_0)).map(ByteArray::new).toArray(ByteArray[]::new);
    }

    @Override
    public Geometry getBinGeometry(ByteArray bin, int precision) {
        List coords = H3BinningHelper.h3().h3ToGeoBoundary(Lexicoders.LONG.fromByteArray(bin.getBytes()).longValue());
        coords.add(coords.get(0));
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon((Coordinate[])coords.stream().map(geoCoord -> new Coordinate(geoCoord.lng, geoCoord.lat)).toArray(Coordinate[]::new));
    }

    @Override
    public String binToString(byte[] binId) {
        return H3BinningHelper.h3().h3ToString(Lexicoders.LONG.fromByteArray(binId).longValue());
    }

    @Override
    public int getBinByteLength(int precision) {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings
    private static H3Core h3() {
        if (h3Core == null) {
            Object object = H3_MUTEX;
            synchronized (object) {
                if (h3Core == null) {
                    try {
                        h3Core = H3Core.newInstance();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to load native H3 libraries", (Throwable)e);
                    }
                }
            }
        }
        return h3Core;
    }

    private static class H3GeometryHandler
    implements GeometryUtils.GeometryHandler {
        private final int precision;
        private final Set<Long> ids = new HashSet<Long>();
        private static final double KM_PER_DEGREE = 111.0;
        private final boolean hasBeenBuffered;

        public H3GeometryHandler(int precision) {
            this(precision, false);
        }

        public H3GeometryHandler(int precision, boolean hasBeenBuffered) {
            this.precision = precision;
            this.hasBeenBuffered = hasBeenBuffered;
        }

        @Override
        public void handlePoint(Point point) {
            this.ids.add(H3BinningHelper.h3().geoToH3(point.getY(), point.getX(), this.precision));
        }

        private Long coordToH3(Coordinate coord) {
            return H3BinningHelper.h3().geoToH3(coord.getY(), coord.getX(), this.precision);
        }

        @Override
        public void handleLineString(LineString lineString) {
            double edgeLengthDegrees = H3BinningHelper.h3().edgeLength(this.precision, LengthUnit.km) / 111.0;
            this.internalHandlePolygon((Polygon)lineString.buffer(edgeLengthDegrees));
            Coordinate[] coords = lineString.getCoordinates();
            if (coords.length > 1) {
                Coordinate prev = coords[0];
                for (int i = 1; i < coords.length; ++i) {
                    try {
                        this.ids.addAll(H3BinningHelper.h3().h3Line(this.coordToH3(prev).longValue(), this.coordToH3(coords[i]).longValue()));
                    }
                    catch (LineUndefinedException e) {
                        LOGGER.error("Unable to add H3 line for " + lineString, (Throwable)e);
                    }
                    prev = coords[i];
                }
            } else if (coords.length == 1) {
                this.ids.add(this.coordToH3(coords[0]));
            }
        }

        private void internalHandlePolygon(Polygon polygon) {
            List idsToAdd;
            int numInteriorRings = polygon.getNumInteriorRing();
            if (numInteriorRings > 0) {
                ArrayList holes = new ArrayList(numInteriorRings);
                for (int i = 0; i < numInteriorRings; ++i) {
                    holes.add(Arrays.stream(polygon.getInteriorRingN(i).getCoordinates()).map(c -> new GeoCoord(c.getY(), c.getX())).collect(Collectors.toList()));
                }
                idsToAdd = H3BinningHelper.h3().polyfill(Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(c -> new GeoCoord(c.getY(), c.getX())).collect(Collectors.toList()), holes, this.precision);
            } else {
                idsToAdd = H3BinningHelper.h3().polyfill(Arrays.stream(polygon.getExteriorRing().getCoordinates()).map(c -> new GeoCoord(c.getY(), c.getX())).collect(Collectors.toList()), null, this.precision);
            }
            if (idsToAdd.isEmpty()) {
                this.handlePoint(polygon.getCentroid());
            } else {
                this.ids.addAll(idsToAdd);
            }
        }

        @Override
        public void handlePolygon(Polygon polygon) {
            if (this.hasBeenBuffered) {
                this.internalHandlePolygon(polygon);
            } else {
                double edgeLengthDegrees = H3BinningHelper.h3().edgeLength(this.precision, LengthUnit.km) / 111.0;
                H3GeometryHandler handler = new H3GeometryHandler(this.precision, true);
                GeometryUtils.visitGeometry(polygon.buffer(edgeLengthDegrees), handler);
                this.ids.addAll(handler.ids);
            }
        }
    }
}

