/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.binning;

import com.github.davidmoten.geo.Coverage;
import com.github.davidmoten.geo.GeoHash;
import com.github.davidmoten.geo.LatLong;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.geowave.core.geotime.binning.SpatialBinningHelper;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.ByteArray;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class GeohashBinningHelper
implements SpatialBinningHelper {
    @Override
    public ByteArray[] getSpatialBins(Geometry geometry, int precision) {
        GeohashGeometryHandler geometryHandler = new GeohashGeometryHandler(precision);
        GeometryUtils.visitGeometry(geometry, geometryHandler);
        return (ByteArray[])geometryHandler.hashes.stream().map(ByteArray::new).toArray(ByteArray[]::new);
    }

    @Override
    public Geometry getBinGeometry(ByteArray bin, int precision) {
        double halfWidth = GeoHash.widthDegrees((int)precision) / 2.0;
        double halfHeight = GeoHash.heightDegrees((int)precision) / 2.0;
        LatLong ll = GeoHash.decodeHash((String)bin.getString());
        return GeometryUtils.GEOMETRY_FACTORY.toGeometry(new Envelope(ll.getLon() - halfWidth, ll.getLon() + halfWidth, ll.getLat() - halfHeight, ll.getLat() + halfHeight));
    }

    @Override
    public String binToString(byte[] binId) {
        return StringUtils.stringFromBinary((byte[])binId);
    }

    private static class GeohashGeometryHandler
    implements GeometryUtils.GeometryHandler {
        private final int precision;
        private final Set<String> hashes = new HashSet<String>();
        private final double halfHeight;
        private final double halfWidth;

        public GeohashGeometryHandler(int precision) {
            this.precision = precision;
            this.halfHeight = GeoHash.heightDegrees((int)precision) / 2.0;
            this.halfWidth = GeoHash.widthDegrees((int)precision) / 2.0;
        }

        @Override
        public void handlePoint(Point point) {
            this.hashes.add(GeoHash.encodeHash((double)point.getY(), (double)point.getX(), (int)this.precision));
        }

        @Override
        public void handleLineString(LineString lineString) {
            double minx = lineString.getEnvelopeInternal().getMinX();
            double maxx = lineString.getEnvelopeInternal().getMaxX();
            double miny = lineString.getEnvelopeInternal().getMinY();
            double maxy = lineString.getEnvelopeInternal().getMaxY();
            Coverage coverage = GeoHash.coverBoundingBox((double)maxy, (double)minx, (double)miny, (double)maxx, (int)this.precision);
            this.hashes.addAll(coverage.getHashes().stream().filter(geohash -> {
                LatLong ll = GeoHash.decodeHash((String)geohash);
                return lineString.intersects(GeometryUtils.GEOMETRY_FACTORY.toGeometry(new Envelope(ll.getLon() - this.halfWidth, ll.getLon() + this.halfWidth, ll.getLat() - this.halfHeight, ll.getLat() + this.halfHeight)));
            }).collect(Collectors.toList()));
        }

        @Override
        public void handlePolygon(Polygon polygon) {
            double minx = polygon.getEnvelopeInternal().getMinX();
            double maxx = polygon.getEnvelopeInternal().getMaxX();
            double miny = polygon.getEnvelopeInternal().getMinY();
            double maxy = polygon.getEnvelopeInternal().getMaxY();
            Coverage coverage = GeoHash.coverBoundingBox((double)maxy, (double)minx, (double)miny, (double)maxx, (int)this.precision);
            if (polygon.equalsExact(polygon.getEnvelope())) {
                this.hashes.addAll(coverage.getHashes());
            } else {
                this.hashes.addAll(coverage.getHashes().stream().filter(geohash -> {
                    LatLong ll = GeoHash.decodeHash((String)geohash);
                    return polygon.intersects(GeometryUtils.GEOMETRY_FACTORY.toGeometry(new Envelope(ll.getLon() - this.halfWidth, ll.getLon() + this.halfWidth, ll.getLat() - this.halfHeight, ll.getLat() + this.halfHeight)));
                }).collect(Collectors.toList()));
            }
        }
    }
}

