/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter.annotation;

import java.lang.reflect.Field;
import org.locationtech.geowave.core.geotime.adapter.TemporalFieldDescriptorBuilder;
import org.locationtech.geowave.core.geotime.adapter.annotation.GeoWaveTemporalField;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.store.adapter.BasicDataTypeAdapter;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.adapter.annotation.AnnotatedFieldDescriptorBuilder;

public class TemporalAnnotatedFieldDescriptorBuilder
implements AnnotatedFieldDescriptorBuilder {
    public FieldDescriptor<?> buildFieldDescriptor(Field field) {
        if (field.isAnnotationPresent(GeoWaveTemporalField.class)) {
            GeoWaveTemporalField fieldAnnotation = field.getAnnotation(GeoWaveTemporalField.class);
            String fieldName = fieldAnnotation.name().isEmpty() ? field.getName() : fieldAnnotation.name();
            String[] indexHints = fieldAnnotation.indexHints();
            TemporalFieldDescriptorBuilder builder = new TemporalFieldDescriptorBuilder(BasicDataTypeAdapter.normalizeClass(field.getType()));
            for (String hint : indexHints) {
                builder.indexHint(new IndexDimensionHint(hint));
            }
            if (fieldAnnotation.timeIndexHint()) {
                builder.timeIndexHint();
            }
            if (fieldAnnotation.startTimeIndexHint()) {
                builder.startTimeIndexHint();
            }
            if (fieldAnnotation.endTimeIndexHint()) {
                builder.endTimeIndexHint();
            }
            return ((TemporalFieldDescriptorBuilder)builder.fieldName(fieldName)).build();
        }
        throw new RuntimeException("Field is missing GeoWaveTemporalField annotation.");
    }
}

