/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter.annotation;

import java.lang.reflect.Field;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptorBuilder;
import org.locationtech.geowave.core.geotime.adapter.annotation.GeoWaveSpatialField;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.store.adapter.BasicDataTypeAdapter;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.adapter.annotation.AnnotatedFieldDescriptorBuilder;
import org.opengis.referencing.FactoryException;

public class SpatialAnnotatedFieldDescriptorBuilder
implements AnnotatedFieldDescriptorBuilder {
    public FieldDescriptor<?> buildFieldDescriptor(Field field) {
        if (field.isAnnotationPresent(GeoWaveSpatialField.class)) {
            GeoWaveSpatialField fieldAnnotation = field.getAnnotation(GeoWaveSpatialField.class);
            String fieldName = fieldAnnotation.name().isEmpty() ? field.getName() : fieldAnnotation.name();
            String[] indexHints = fieldAnnotation.indexHints();
            SpatialFieldDescriptorBuilder builder = new SpatialFieldDescriptorBuilder(BasicDataTypeAdapter.normalizeClass(field.getType()));
            for (String hint : indexHints) {
                builder.indexHint(new IndexDimensionHint(hint));
            }
            if (!fieldAnnotation.crs().isEmpty()) {
                try {
                    builder.crs(CRS.decode((String)fieldAnnotation.crs()));
                }
                catch (FactoryException e) {
                    throw new RuntimeException("Unable to decode CRS: " + fieldAnnotation.crs(), e);
                }
            }
            if (fieldAnnotation.spatialIndexHint()) {
                builder.spatialIndexHint();
            }
            if (fieldAnnotation.latitudeIndexHint()) {
                builder.latitudeIndexHint();
            }
            if (fieldAnnotation.longitudeIndexHint()) {
                builder.longitudeIndexHint();
            }
            return ((SpatialFieldDescriptorBuilder)builder.fieldName(fieldName)).build();
        }
        throw new RuntimeException("Field is missing GeoWaveSpatialField annotation.");
    }
}

