/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.locationtech.geowave.core.geotime.adapter.TemporalIntervalFieldMapper;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.threeten.extra.Interval;

public abstract class TimeRangeFieldMapper<N>
extends TemporalIntervalFieldMapper<N> {
    private static Set<String> suggestedStartTimeFieldNames = Sets.newHashSet((Object[])new String[]{"starttime", "start", "start_time"});
    private static Set<String> suggestedEndTimeNames = Sets.newHashSet((Object[])new String[]{"endtime", "end", "end_time"});
    private boolean startFirst = true;

    @Override
    public void initFromOptions(List<FieldDescriptor<N>> inputFieldDescriptors, IndexFieldMapper.IndexFieldOptions options) {
        if (inputFieldDescriptors.size() != 2) {
            throw new RuntimeException("Time range field mapper expects exactly 2 fields.");
        }
        this.startFirst = inputFieldDescriptors.get(0).indexHints().contains(TimeField.START_TIME_DIMENSION_HINT) || !inputFieldDescriptors.get(1).indexHints().contains(TimeField.START_TIME_DIMENSION_HINT) || suggestedStartTimeFieldNames.contains(inputFieldDescriptors.get(0).fieldName().toLowerCase());
        super.initFromOptions(inputFieldDescriptors, options);
    }

    public String[] getIndexOrderedAdapterFields() {
        if (!this.startFirst) {
            return new String[]{this.adapterFields[1], this.adapterFields[0]};
        }
        return this.adapterFields;
    }

    public Interval toIndex(List<N> nativeFieldValues) {
        if (this.startFirst) {
            return TimeUtils.getInterval(nativeFieldValues.get(0), nativeFieldValues.get(1));
        }
        return TimeUtils.getInterval(nativeFieldValues.get(1), nativeFieldValues.get(0));
    }

    public void toAdapter(Interval indexFieldValue, RowBuilder<?> rowBuilder) {
        if (this.startFirst) {
            rowBuilder.setField(this.adapterFields[0], TimeUtils.getTimeValue(this.adapterFieldType(), indexFieldValue.getStart().toEpochMilli()));
            rowBuilder.setField(this.adapterFields[1], TimeUtils.getTimeValue(this.adapterFieldType(), indexFieldValue.getEnd().toEpochMilli()));
        } else {
            rowBuilder.setField(this.adapterFields[1], TimeUtils.getTimeValue(this.adapterFieldType(), indexFieldValue.getStart().toEpochMilli()));
            rowBuilder.setField(this.adapterFields[0], TimeUtils.getTimeValue(this.adapterFieldType(), indexFieldValue.getEnd().toEpochMilli()));
        }
    }

    public short adapterFieldCount() {
        return 2;
    }

    public Set<String> getLowerCaseSuggestedFieldNames() {
        return Sets.newHashSet((Iterable)Iterables.concat(suggestedStartTimeFieldNames, suggestedEndTimeNames));
    }

    protected int byteLength() {
        return super.byteLength() + 1;
    }

    protected void writeBytes(ByteBuffer buffer) {
        super.writeBytes(buffer);
        buffer.put((byte)(this.startFirst ? 1 : 0));
    }

    protected void readBytes(ByteBuffer buffer) {
        super.readBytes(buffer);
        this.startFirst = buffer.get() != 0;
    }

    public static class LongRangeFieldMapper
    extends TimeRangeFieldMapper<Long> {
        public Class<Long> adapterFieldType() {
            return Long.class;
        }
    }

    public static class DateRangeFieldMapper
    extends TimeRangeFieldMapper<Date> {
        public Class<Date> adapterFieldType() {
            return Date.class;
        }
    }

    public static class CalendarRangeFieldMapper
    extends TimeRangeFieldMapper<Calendar> {
        public Class<Calendar> adapterFieldType() {
            return Calendar.class;
        }
    }
}

