/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.locationtech.geowave.core.geotime.adapter.TemporalIntervalFieldMapper;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.threeten.extra.Interval;

public abstract class TimeInstantFieldMapper<N>
extends TemporalIntervalFieldMapper<N> {
    public Interval toIndex(List<N> nativeFieldValues) {
        return TimeUtils.getInterval(nativeFieldValues.get(0));
    }

    public void toAdapter(Interval indexFieldValue, RowBuilder<?> rowBuilder) {
        rowBuilder.setField(this.adapterFields[0], TimeUtils.getTimeValue(this.adapterFieldType(), indexFieldValue.getStart().toEpochMilli()));
    }

    public short adapterFieldCount() {
        return 1;
    }

    public Set<String> getLowerCaseSuggestedFieldNames() {
        return Sets.newHashSet((Object[])new String[]{"timestamp", "date", "time"});
    }

    public static class LongInstantFieldMapper
    extends TimeInstantFieldMapper<Long> {
        public Class<Long> adapterFieldType() {
            return Long.class;
        }
    }

    public static class DateInstantFieldMapper
    extends TimeInstantFieldMapper<Date> {
        public Class<Date> adapterFieldType() {
            return Date.class;
        }
    }

    public static class CalendarInstantFieldMapper
    extends TimeInstantFieldMapper<Calendar> {
        public Class<Calendar> adapterFieldType() {
            return Calendar.class;
        }
    }
}

