/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.api.RowBuilder;

public abstract class TemporalLongFieldMapper<N>
extends IndexFieldMapper<N, Long> {
    public Class<Long> indexFieldType() {
        return Long.class;
    }

    public void transformFieldDescriptors(FieldDescriptor<?>[] inputFieldDescriptors) {
    }

    protected void initFromOptions(List<FieldDescriptor<N>> inputFieldDescriptors, IndexFieldMapper.IndexFieldOptions options) {
    }

    public short adapterFieldCount() {
        return 1;
    }

    public static class DateLongFieldMapper
    extends TemporalLongFieldMapper<Date> {
        public Class<Date> adapterFieldType() {
            return Date.class;
        }

        public Long toIndex(List<Date> nativeFieldValues) {
            return nativeFieldValues.get(0).getTime();
        }

        public void toAdapter(Long indexFieldValue, RowBuilder<?> rowBuilder) {
            rowBuilder.setField(this.adapterFields[0], (Object)new Date(indexFieldValue));
        }
    }

    public static class CalendarLongFieldMapper
    extends TemporalLongFieldMapper<Calendar> {
        public Class<Calendar> adapterFieldType() {
            return Calendar.class;
        }

        public Long toIndex(List<Calendar> nativeFieldValues) {
            return nativeFieldValues.get(0).getTimeInMillis();
        }

        public void toAdapter(Long indexFieldValue, RowBuilder<?> rowBuilder) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(indexFieldValue);
            rowBuilder.setField(this.adapterFields[0], (Object)calendar);
        }
    }
}

