/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptor;
import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptorBuilder;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpatialFieldMapper<N>
extends IndexFieldMapper<N, Geometry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialFieldMapper.class);
    private CoordinateReferenceSystem adapterCRS = null;
    private CoordinateReferenceSystem indexCRS = null;
    private MathTransform transform = null;
    private byte[] indexCRSBytes = null;
    private byte[] adapterCRSBytes = null;

    public Geometry toIndex(List<N> nativeFieldValues) {
        Geometry nativeGeometry = this.getNativeGeometry(nativeFieldValues);
        try {
            if (this.transform != null) {
                return JTS.transform((Geometry)nativeGeometry, (MathTransform)this.transform);
            }
        }
        catch (MismatchedDimensionException | TransformException e) {
            LOGGER.warn("Unable to perform transform to specified CRS of the index, the feature geometry will remain in its original CRS", e);
        }
        return nativeGeometry;
    }

    protected abstract Geometry getNativeGeometry(List<N> var1);

    public Class<Geometry> indexFieldType() {
        return Geometry.class;
    }

    protected void initFromOptions(List<FieldDescriptor<N>> inputFieldDescriptors, IndexFieldMapper.IndexFieldOptions options) {
        this.indexCRS = GeometryUtils.getDefaultCRS();
        this.adapterCRS = GeometryUtils.getDefaultCRS();
        if (options instanceof SpatialField.SpatialIndexFieldOptions) {
            this.indexCRS = ((SpatialField.SpatialIndexFieldOptions)options).crs();
        }
        for (FieldDescriptor<N> field : inputFieldDescriptors) {
            if (!(field instanceof SpatialFieldDescriptor) || ((SpatialFieldDescriptor)field).crs() == null) continue;
            this.adapterCRS = ((SpatialFieldDescriptor)field).crs();
            break;
        }
        if (!this.indexCRS.equals(this.adapterCRS)) {
            try {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)this.adapterCRS, (CoordinateReferenceSystem)this.indexCRS, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.warn("Unable to create coordinate reference system transform", (Throwable)e);
            }
        }
    }

    public void transformFieldDescriptors(FieldDescriptor<?>[] inputFieldDescriptors) {
        if (!this.indexCRS.equals(this.adapterCRS)) {
            Object[] mappedFields = this.getAdapterFields();
            for (int i = 0; i < inputFieldDescriptors.length; ++i) {
                FieldDescriptor<?> field = inputFieldDescriptors[i];
                if (!ArrayUtils.contains((Object[])mappedFields, (Object)field.fieldName())) continue;
                inputFieldDescriptors[i] = ((SpatialFieldDescriptorBuilder)new SpatialFieldDescriptorBuilder(field.bindingClass()).fieldName(field.fieldName())).crs(this.indexCRS).build();
            }
        }
    }

    protected int byteLength() {
        this.indexCRSBytes = StringUtils.stringToBinary((String)this.indexCRS.toWKT());
        this.adapterCRSBytes = StringUtils.stringToBinary((String)this.adapterCRS.toWKT());
        return super.byteLength() + VarintUtils.unsignedShortByteLength((short)((short)this.indexCRSBytes.length)) + VarintUtils.unsignedShortByteLength((short)((short)this.adapterCRSBytes.length)) + this.indexCRSBytes.length + this.adapterCRSBytes.length;
    }

    protected void writeBytes(ByteBuffer buffer) {
        VarintUtils.writeUnsignedShort((short)((short)this.indexCRSBytes.length), (ByteBuffer)buffer);
        buffer.put(this.indexCRSBytes);
        VarintUtils.writeUnsignedShort((short)((short)this.adapterCRSBytes.length), (ByteBuffer)buffer);
        buffer.put(this.adapterCRSBytes);
        super.writeBytes(buffer);
    }

    protected void readBytes(ByteBuffer buffer) {
        this.indexCRSBytes = new byte[VarintUtils.readUnsignedShort((ByteBuffer)buffer)];
        buffer.get(this.indexCRSBytes);
        this.adapterCRSBytes = new byte[VarintUtils.readUnsignedShort((ByteBuffer)buffer)];
        buffer.get(this.adapterCRSBytes);
        try {
            this.indexCRS = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])this.indexCRSBytes));
            this.adapterCRS = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])this.adapterCRSBytes));
            this.transform = !this.indexCRS.equals(this.adapterCRS) ? CRS.findMathTransform((CoordinateReferenceSystem)this.adapterCRS, (CoordinateReferenceSystem)this.indexCRS, (boolean)true) : null;
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to decode coordinate reference system for spatial index field mapper.");
        }
        super.readBytes(buffer);
    }
}

