/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import org.locationtech.geowave.core.geotime.adapter.SpatialFieldDescriptor;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptorBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialFieldDescriptorBuilder<T>
extends FieldDescriptorBuilder<T, SpatialFieldDescriptor<T>, SpatialFieldDescriptorBuilder<T>> {
    protected CoordinateReferenceSystem crs = GeometryUtils.getDefaultCRS();

    public SpatialFieldDescriptorBuilder(Class<T> bindingClass) {
        super(bindingClass);
    }

    public SpatialFieldDescriptorBuilder<T> spatialIndexHint() {
        return (SpatialFieldDescriptorBuilder)((SpatialFieldDescriptorBuilder)this.indexHint(SpatialField.LONGITUDE_DIMENSION_HINT)).indexHint(SpatialField.LATITUDE_DIMENSION_HINT);
    }

    public SpatialFieldDescriptorBuilder<T> latitudeIndexHint() {
        return (SpatialFieldDescriptorBuilder)this.indexHint(SpatialField.LATITUDE_DIMENSION_HINT);
    }

    public SpatialFieldDescriptorBuilder<T> longitudeIndexHint() {
        return (SpatialFieldDescriptorBuilder)this.indexHint(SpatialField.LONGITUDE_DIMENSION_HINT);
    }

    public SpatialFieldDescriptorBuilder<T> crs(CoordinateReferenceSystem crs) {
        this.crs = crs;
        return this;
    }

    public SpatialFieldDescriptor<T> build() {
        return new SpatialFieldDescriptor(this.bindingClass, this.fieldName, this.indexHints, this.crs);
    }
}

