/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import java.nio.ByteBuffer;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.index.IndexDimensionHint;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.adapter.BaseFieldDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialFieldDescriptor<T>
extends BaseFieldDescriptor<T> {
    private CoordinateReferenceSystem crs;

    public SpatialFieldDescriptor() {
    }

    public SpatialFieldDescriptor(Class<T> bindingClass, String fieldName, Set<IndexDimensionHint> indexHints, CoordinateReferenceSystem crs) {
        super(bindingClass, fieldName, indexHints);
        this.crs = crs;
    }

    public CoordinateReferenceSystem crs() {
        return this.crs;
    }

    public byte[] toBinary() {
        byte[] parentBytes = super.toBinary();
        byte[] crsBytes = StringUtils.stringToBinary((String)this.crs.toWKT());
        ByteBuffer buffer = ByteBuffer.allocate(VarintUtils.unsignedIntByteLength((int)parentBytes.length) + VarintUtils.unsignedIntByteLength((int)crsBytes.length) + parentBytes.length + crsBytes.length);
        VarintUtils.writeUnsignedInt((int)parentBytes.length, (ByteBuffer)buffer);
        buffer.put(parentBytes);
        VarintUtils.writeUnsignedInt((int)crsBytes.length, (ByteBuffer)buffer);
        buffer.put(crsBytes);
        return buffer.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] parentBytes = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buffer)];
        buffer.get(parentBytes);
        super.fromBinary(parentBytes);
        byte[] crsBytes = new byte[VarintUtils.readUnsignedInt((ByteBuffer)buffer)];
        buffer.get(crsBytes);
        try {
            this.crs = CRS.parseWKT((String)StringUtils.stringFromBinary((byte[])crsBytes));
        }
        catch (FactoryException e) {
            throw new RuntimeException("Unable to decode coordinate reference system for spatial field descriptor.");
        }
    }
}

