/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.adapter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.locationtech.geowave.core.geotime.adapter.SpatialFieldMapper;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.adapter.FieldDescriptor;
import org.locationtech.geowave.core.store.api.IndexFieldMapper;
import org.locationtech.geowave.core.store.api.RowBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class LatLonFieldMapper<N>
extends SpatialFieldMapper<N> {
    private static Set<String> suggestedLongitudeFieldNames = Sets.newHashSet((Object[])new String[]{"longitude", "lon", "x"});
    private static Set<String> suggestedLatitudeFieldNames = Sets.newHashSet((Object[])new String[]{"latitude", "lat", "y"});
    protected boolean xAxisFirst = true;

    @Override
    public void initFromOptions(List<FieldDescriptor<N>> inputFieldDescriptors, IndexFieldMapper.IndexFieldOptions options) {
        if (inputFieldDescriptors.size() != 2) {
            throw new RuntimeException("Latitude/Longitude index field mapper expects exactly 2 fields.");
        }
        if (inputFieldDescriptors.get(0).indexHints().contains(SpatialField.LONGITUDE_DIMENSION_HINT) && inputFieldDescriptors.get(1).indexHints().contains(SpatialField.LONGITUDE_DIMENSION_HINT)) {
            throw new RuntimeException("Two longitude dimension hints were given.");
        }
        if (inputFieldDescriptors.get(0).indexHints().contains(SpatialField.LATITUDE_DIMENSION_HINT) && inputFieldDescriptors.get(1).indexHints().contains(SpatialField.LATITUDE_DIMENSION_HINT)) {
            throw new RuntimeException("Two latitude dimension hints were given.");
        }
        this.xAxisFirst = inputFieldDescriptors.get(0).indexHints().contains(SpatialField.LONGITUDE_DIMENSION_HINT) || inputFieldDescriptors.get(1).indexHints().contains(SpatialField.LATITUDE_DIMENSION_HINT) || suggestedLongitudeFieldNames.contains(inputFieldDescriptors.get(0).fieldName().toLowerCase());
        super.initFromOptions(inputFieldDescriptors, options);
    }

    public String[] getIndexOrderedAdapterFields() {
        if (!this.xAxisFirst) {
            return new String[]{this.adapterFields[1], this.adapterFields[0]};
        }
        return this.adapterFields;
    }

    public void toAdapter(Geometry indexFieldValue, RowBuilder<?> rowBuilder) {
        Point centroid = indexFieldValue.getCentroid();
        if (this.xAxisFirst) {
            this.setField(this.adapterFields[0], centroid.getX(), rowBuilder);
            this.setField(this.adapterFields[1], centroid.getY(), rowBuilder);
        }
        this.setField(this.adapterFields[0], centroid.getY(), rowBuilder);
        this.setField(this.adapterFields[1], centroid.getX(), rowBuilder);
    }

    protected abstract void setField(String var1, Double var2, RowBuilder<?> var3);

    @Override
    protected Geometry getNativeGeometry(List<N> nativeFieldValues) {
        Coordinate coordinate = this.xAxisFirst ? this.toCoordinate(nativeFieldValues.get(0), nativeFieldValues.get(1)) : this.toCoordinate(nativeFieldValues.get(1), nativeFieldValues.get(0));
        return GeometryUtils.GEOMETRY_FACTORY.createPoint(coordinate);
    }

    protected abstract Coordinate toCoordinate(N var1, N var2);

    public short adapterFieldCount() {
        return 2;
    }

    public Set<String> getLowerCaseSuggestedFieldNames() {
        return Sets.newHashSet((Iterable)Iterables.concat(suggestedLongitudeFieldNames, suggestedLatitudeFieldNames));
    }

    @Override
    protected int byteLength() {
        return super.byteLength() + 1;
    }

    @Override
    protected void writeBytes(ByteBuffer buffer) {
        super.writeBytes(buffer);
        buffer.put((byte)(this.xAxisFirst ? 1 : 0));
    }

    @Override
    protected void readBytes(ByteBuffer buffer) {
        super.readBytes(buffer);
        this.xAxisFirst = buffer.get() != 0;
    }

    public static class FloatLatLonFieldMapper
    extends LatLonFieldMapper<Float> {
        public Class<Float> adapterFieldType() {
            return Float.class;
        }

        @Override
        protected void setField(String fieldName, Double value, RowBuilder<?> rowBuilder) {
            rowBuilder.setField(fieldName, (Object)Float.valueOf(value.floatValue()));
        }

        @Override
        protected Coordinate toCoordinate(Float xValue, Float yValue) {
            return new Coordinate((double)xValue.floatValue(), (double)yValue.floatValue());
        }
    }

    public static class DoubleLatLonFieldMapper
    extends LatLonFieldMapper<Double> {
        public Class<Double> adapterFieldType() {
            return Double.class;
        }

        @Override
        protected void setField(String fieldName, Double value, RowBuilder<?> rowBuilder) {
            rowBuilder.setField(fieldName, (Object)value);
        }

        @Override
        protected Coordinate toCoordinate(Double xValue, Double yValue) {
            return new Coordinate(xValue.doubleValue(), yValue.doubleValue());
        }
    }
}

