/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.util;

import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.filter.visitor.NullFilterVisitor;
import org.geotools.util.Converters;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraints;
import org.locationtech.geowave.core.geotime.store.query.TemporalConstraintsSet;
import org.locationtech.geowave.core.geotime.store.query.TemporalRange;
import org.locationtech.geowave.core.geotime.util.TimeDescriptors;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

public class ExtractTimeFilterVisitor
extends NullFilterVisitor {
    private final List<String[]> validParamRanges = new LinkedList<String[]>();
    private boolean approximation = false;

    public ExtractTimeFilterVisitor() {
    }

    public ExtractTimeFilterVisitor(TimeDescriptors timeDescriptors) {
        if (timeDescriptors.hasTime() && timeDescriptors.getStartRange() != null && timeDescriptors.getEndRange() != null) {
            this.addRangeVariables(timeDescriptors.getStartRange().getLocalName(), timeDescriptors.getEndRange().getLocalName());
        }
    }

    public void addRangeVariables(String start, String end) {
        this.validParamRanges.add(new String[]{start, end});
    }

    public TemporalConstraintsSet getConstraints(Filter filter) {
        TemporalConstraintsSet constrainsSet = this.getRawConstraints(filter);
        constrainsSet.setExact(!this.approximation);
        for (String[] range : this.validParamRanges) {
            if (!constrainsSet.hasConstraintsFor(range[0]) && !constrainsSet.hasConstraintsFor(range[1])) continue;
            TemporalConstraints start = constrainsSet.hasConstraintsFor(range[0]) ? constrainsSet.getConstraintsFor(range[0]) : constrainsSet.getConstraintsFor(range[1]);
            TemporalConstraints end = constrainsSet.hasConstraintsFor(range[1]) ? constrainsSet.getConstraintsFor(range[1]) : start;
            constrainsSet.removeConstraints(range[0], range[1]);
            TemporalConstraints constraintsForRange = constrainsSet.getConstraintsForRange(range[0], range[1]);
            constraintsForRange.replaceWithIntersections(new TemporalConstraints(new TemporalRange(start.getStartRange().getStartTime(), end.getEndRange().getEndTime()), constraintsForRange.getName()));
        }
        return constrainsSet;
    }

    public TemporalConstraintsSet getConstraints(Query query) {
        return this.getConstraints(query.getFilter());
    }

    private TemporalConstraintsSet getRawConstraints(Filter filter) {
        Object output = filter.accept((FilterVisitor)this, null);
        if (output instanceof TemporalConstraintsSet) {
            return (TemporalConstraintsSet)output;
        }
        if (output instanceof ParameterTimeConstraint) {
            ParameterTimeConstraint paramConstraint = (ParameterTimeConstraint)output;
            TemporalConstraintsSet constraintSet = new TemporalConstraintsSet();
            constraintSet.getConstraintsFor(paramConstraint.getName()).replaceWithMerged(paramConstraint);
            return constraintSet;
        }
        return new TemporalConstraintsSet();
    }

    private TemporalConstraints btime(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Date) {
            return this.toSet(new TemporalRange((Date)data, (Date)data));
        }
        if (data instanceof Timestamp) {
            return this.toSet(new TemporalRange((Timestamp)data, (Timestamp)data));
        }
        if (data instanceof Number) {
            long val = ((Number)data).longValue();
            return this.toSet(new TemporalRange(new Date(val), new Date(val)));
        }
        if (data instanceof TemporalRange) {
            return this.toSet((TemporalRange)data);
        }
        if (data instanceof TemporalConstraints) {
            return (TemporalConstraints)data;
        }
        if (data instanceof Period) {
            Position beginPosition = ((Period)data).getBeginning().getPosition();
            Position endPosition = ((Period)data).getEnding().getPosition();
            Date s = TemporalRange.START_TIME;
            Date e = TemporalRange.START_TIME;
            if (beginPosition.getDate() != null) {
                s = new Date(beginPosition.getDate().getTime() + 1L);
            } else if (beginPosition.getTime() != null) {
                s = new Date(beginPosition.getTime().getTime() + 1L);
            }
            if (endPosition.getDate() != null) {
                e = new Date(endPosition.getDate().getTime() - 1L);
            } else if (endPosition.getTime() != null) {
                e = new Date(endPosition.getTime().getTime() - 1L);
            }
            if (s.getTime() > e.getTime()) {
                return new TemporalConstraints();
            }
            return this.toSet(new TemporalRange(s, e));
        }
        if (data instanceof Instant) {
            Position beginPosition = ((Instant)data).getPosition();
            Date s = TemporalRange.START_TIME;
            if (beginPosition.getDate() != null) {
                s = beginPosition.getDate();
            } else if (beginPosition.getTime() != null) {
                s = beginPosition.getTime();
            }
            return this.toSet(new TemporalRange(s, s));
        }
        Date convertedDate = (Date)Converters.convert((Object)data, Date.class);
        if (convertedDate != null) {
            return this.btime(convertedDate);
        }
        return new TemporalConstraints();
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(IncludeFilter filter, Object data) {
        return new TemporalConstraints();
    }

    private TemporalConstraints toSet(TemporalRange range) {
        TemporalConstraints contraints = new TemporalConstraints();
        contraints.add(range);
        return contraints;
    }

    public Object visit(Literal expression, Object data) {
        Object value = expression.getValue();
        return this.btime(value);
    }

    public Object visit(And filter, Object data) {
        TemporalConstraintsSet constraints = new TemporalConstraintsSet();
        for (Filter f : filter.getChildren()) {
            Object output = f.accept((FilterVisitor)this, data);
            if (output instanceof ParameterTimeConstraint) {
                ParameterTimeConstraint ranges = (ParameterTimeConstraint)output;
                constraints.getConstraintsFor(ranges.getName()).replaceWithIntersections(ranges);
                continue;
            }
            if (!(output instanceof TemporalConstraintsSet)) continue;
            TemporalConstraintsSet rangeSet = (TemporalConstraintsSet)output;
            for (Map.Entry<String, TemporalConstraints> entry : rangeSet.getSet()) {
                constraints.getConstraintsFor(entry.getKey()).replaceWithIntersections(entry.getValue());
            }
        }
        for (String[] range : this.validParamRanges) {
            if (!constraints.hasConstraintsFor(range[0]) || !constraints.hasConstraintsFor(range[1])) continue;
            TemporalConstraints start = constraints.getConstraintsFor(range[0]);
            TemporalConstraints end = constraints.getConstraintsFor(range[1]);
            constraints.removeConstraints(range[0], range[1]);
            if (start.getEndRange().getEndTime().after(end.getStartRange().getStartTime())) {
                constraints.getConstraintsForRange(range[0], range[1]).add(new TemporalRange(end.getStartRange().getStartTime(), start.getEndRange().getEndTime()));
                continue;
            }
            this.approximation |= start.getRanges().size() > 1 || end.getRanges().size() > 1;
            constraints.getConstraintsForRange(range[0], range[1]).add(new TemporalRange(start.getStartRange().getStartTime(), end.getEndRange().getEndTime()));
        }
        return constraints;
    }

    public boolean isApproximation() {
        return this.approximation;
    }

    public Object visit(Not filter, Object data) {
        Object output = filter.getFilter().accept((FilterVisitor)this, data);
        if (output instanceof ParameterTimeConstraint) {
            return this.not((ParameterTimeConstraint)output);
        }
        if (output instanceof TemporalConstraintsSet) {
            TemporalConstraintsSet newRangeSet = new TemporalConstraintsSet();
            TemporalConstraintsSet rangeSet = (TemporalConstraintsSet)output;
            for (Map.Entry<String, TemporalConstraints> entry : rangeSet.getSet()) {
                newRangeSet.getConstraintsFor(entry.getKey()).replaceWithMerged(this.not(entry.getValue()));
            }
            return newRangeSet;
        }
        return output;
    }

    private TemporalConstraints not(TemporalConstraints constraints) {
        ParameterTimeConstraint notRanges = new ParameterTimeConstraint(constraints.getName());
        notRanges.empty();
        Date lastMax = TemporalRange.START_TIME;
        for (TemporalRange range : constraints.getRanges()) {
            if (range.getStartTime().after(TemporalRange.START_TIME)) {
                notRanges.add(new TemporalRange(lastMax, new Date(range.getStartTime().getTime() - 1L)));
            }
            lastMax = range.getEndTime();
        }
        if (!constraints.isEmpty() && TemporalRange.END_TIME.after(constraints.getEndRange().getEndTime())) {
            notRanges.add(new TemporalRange(lastMax, TemporalRange.END_TIME));
        }
        return notRanges;
    }

    public Object visit(Or filter, Object data) {
        TemporalConstraintsSet constraints = new TemporalConstraintsSet();
        for (Filter f : filter.getChildren()) {
            Object output = f.accept((FilterVisitor)this, data);
            if (output instanceof ParameterTimeConstraint) {
                ParameterTimeConstraint ranges = (ParameterTimeConstraint)output;
                constraints.getConstraintsFor(ranges.getName()).replaceWithMerged(ranges);
                continue;
            }
            if (!(output instanceof TemporalConstraintsSet)) continue;
            TemporalConstraintsSet rangeSet = (TemporalConstraintsSet)output;
            for (Map.Entry<String, TemporalConstraints> entry : rangeSet.getSet()) {
                constraints.getConstraintsFor(entry.getKey()).replaceWithMerged(entry.getValue());
            }
        }
        return constraints;
    }

    public Object visit(After after, Object data) {
        TemporalConstraints leftResult = this.btime(after.getExpression1().accept((ExpressionVisitor)this, data));
        TemporalConstraints rightResult = this.btime(after.getExpression2().accept((ExpressionVisitor)this, data));
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getMaxOr(TemporalRange.START_TIME, 1), TemporalRange.END_TIME), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getMinOr(TemporalRange.END_TIME, -1)), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(AnyInteracts anyInteracts, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Before before, Object data) {
        TemporalConstraints leftResult = this.btime(before.getExpression1().accept((ExpressionVisitor)this, data));
        TemporalConstraints rightResult = this.btime(before.getExpression2().accept((ExpressionVisitor)this, data));
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, rightResult.getMinOr(TemporalRange.END_TIME, -1)), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(leftResult.getMaxOr(TemporalRange.START_TIME, 1), TemporalRange.END_TIME), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(Begins begins, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)begins.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)begins.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(rightResult.getRanges(), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(leftResult.getMinOr(TemporalRange.START_TIME, 0), TemporalRange.END_TIME), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(BegunBy begunBy, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)begunBy.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)begunBy.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getMinOr(TemporalRange.START_TIME, 0), TemporalRange.END_TIME), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(leftResult.getRanges(), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(During during, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)during.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)during.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(rightResult.getRanges(), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return rightResult;
        }
        return new TemporalConstraints();
    }

    public Object visit(EndedBy endedBy, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)endedBy.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)endedBy.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, rightResult.getMaxOr(TemporalRange.END_TIME, 0)), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(leftResult.getRanges(), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(Ends ends, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)ends.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)ends.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(rightResult.getRanges(), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getMaxOr(TemporalRange.END_TIME, 0)), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(Meets meets, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)meets.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)meets.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, rightResult.getMinOr(TemporalRange.END_TIME, 0)), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(MetBy metBy, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)metBy.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)metBy.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getMaxOr(TemporalRange.START_TIME, 0), TemporalRange.END_TIME), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getMinOr(TemporalRange.END_TIME, 0)), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(OverlappedBy overlappedBy, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)overlappedBy.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)overlappedBy.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getMinOr(TemporalRange.START_TIME, 1), TemporalRange.END_TIME), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getMaxOr(TemporalRange.END_TIME, -1)), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(TContains contains, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)contains.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)contains.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new TemporalConstraints(new TemporalRange(TemporalRange.START_TIME, rightResult.getMaxOr(TemporalRange.END_TIME, -1)), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(leftResult.getRanges(), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(TEquals equals, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)equals.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)equals.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return rightResult;
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return leftResult;
        }
        return new TemporalConstraints();
    }

    public Object visit(TOverlaps overlaps, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)overlaps.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)overlaps.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new TemporalConstraints(new TemporalRange(TemporalRange.START_TIME, rightResult.getMaxOr(TemporalRange.END_TIME, -1)), leftResult.getName());
        }
        if (rightResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(leftResult.getMaxOr(TemporalRange.START_TIME, -1), TemporalRange.END_TIME), rightResult.getName());
        }
        return new TemporalConstraints();
    }

    public Object visit(Id filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        TemporalConstraints propertyExp = (TemporalConstraints)filter.getExpression().accept((ExpressionVisitor)this, data);
        TemporalConstraints lowerBound = (TemporalConstraints)filter.getLowerBoundary().accept((ExpressionVisitor)this, data);
        TemporalConstraints upperBound = (TemporalConstraints)filter.getUpperBoundary().accept((ExpressionVisitor)this, data);
        if (propertyExp.isEmpty()) {
            return new TemporalConstraints();
        }
        return new ParameterTimeConstraint(new TemporalRange(lowerBound.getStartRange().getStartTime(), upperBound.getEndRange().getEndTime()), propertyExp.getName());
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getStartRange().getStartTime(), rightResult.getEndRange().getEndTime()), leftResult.getName());
        }
        return new ParameterTimeConstraint(new TemporalRange(leftResult.getStartRange().getStartTime(), leftResult.getEndRange().getEndTime()), rightResult.getName());
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            ParameterTimeConstraint constraints = new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, rightResult.getStartRange().getStartTime()), leftResult.getName());
            constraints.add(new TemporalRange(rightResult.getEndRange().getEndTime(), TemporalRange.END_TIME));
            return constraints;
        }
        ParameterTimeConstraint constraints = new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getStartRange().getStartTime()), rightResult.getName());
        constraints.add(new TemporalRange(leftResult.getEndRange().getEndTime(), TemporalRange.END_TIME));
        return constraints;
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(new Date(rightResult.getStartRange().getStartTime().getTime() + 1L), TemporalRange.END_TIME), leftResult.getName());
        }
        return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, new Date(leftResult.getStartRange().getStartTime().getTime() - 1L)), rightResult.getName());
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(rightResult.getStartRange().getStartTime(), TemporalRange.END_TIME), leftResult.getName());
        }
        return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, leftResult.getStartRange().getStartTime()), rightResult.getName());
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, new Date(rightResult.getStartRange().getStartTime().getTime() - 1L)), leftResult.getName());
        }
        return new ParameterTimeConstraint(new TemporalRange(new Date(leftResult.getStartRange().getStartTime().getTime() + 1L), TemporalRange.END_TIME), rightResult.getName());
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        TemporalConstraints leftResult = (TemporalConstraints)filter.getExpression1().accept((ExpressionVisitor)this, data);
        TemporalConstraints rightResult = (TemporalConstraints)filter.getExpression2().accept((ExpressionVisitor)this, data);
        if (leftResult.isEmpty() || rightResult.isEmpty()) {
            return new TemporalConstraints();
        }
        if (leftResult instanceof ParameterTimeConstraint) {
            return new ParameterTimeConstraint(new TemporalRange(TemporalRange.START_TIME, rightResult.getStartRange().getStartTime()), leftResult.getName());
        }
        return new ParameterTimeConstraint(new TemporalRange(leftResult.getStartRange().getStartTime(), TemporalRange.END_TIME), rightResult.getName());
    }

    public Object visit(PropertyIsLike filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(PropertyIsNull filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(PropertyIsNil filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(BBOX filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Beyond filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Contains filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Crosses filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Disjoint filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(DWithin filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Equals filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Intersects filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Overlaps filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Touches filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Within filter, Object data) {
        return new TemporalConstraints();
    }

    public Object visitNullFilter(Object data) {
        return new TemporalConstraints();
    }

    public Object visit(NilExpression expression, Object data) {
        return new TemporalConstraints();
    }

    public Object visit(Add expression, Object data) {
        return expression.accept((ExpressionVisitor)this, data);
    }

    public Object visit(Divide expression, Object data) {
        return expression.accept((ExpressionVisitor)this, data);
    }

    public Object visit(Function expression, Object data) {
        return new TemporalConstraints();
    }

    private boolean validateName(String name) {
        return true;
    }

    public Object visit(PropertyName expression, Object data) {
        String name = expression.getPropertyName();
        if (this.validateName(expression.getPropertyName())) {
            return new ParameterTimeConstraint(name);
        }
        return new TemporalConstraints();
    }

    public Object visit(Subtract expression, Object data) {
        return expression.accept((ExpressionVisitor)this, data);
    }

    private boolean expressionContainsTime(Expression expression) {
        return !((TemporalConstraints)expression.accept((ExpressionVisitor)this, null)).isEmpty();
    }

    private boolean containsTime(Function function) {
        boolean yes = false;
        for (Expression expression : function.getParameters()) {
            yes |= this.expressionContainsTime(expression);
        }
        return yes;
    }

    private static class ParameterTimeConstraint
    extends TemporalConstraints {
        public ParameterTimeConstraint(String name) {
            super(TemporalConstraints.FULL_RANGE, name);
        }

        public ParameterTimeConstraint(List<TemporalRange> ranges, String name) {
            super(ranges, name);
        }

        public ParameterTimeConstraint(TemporalRange range, String name) {
            super(range, name);
        }

        public TemporalConstraints bounds(TemporalConstraints other) {
            return other;
        }
    }
}

