/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.statistics;

import org.locationtech.geowave.core.geotime.store.statistics.BoundingBoxDataStatistics;
import org.locationtech.geowave.core.geotime.store.statistics.FieldNameStatistic;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.adapter.statistics.FieldStatisticsQueryBuilder;
import org.locationtech.geowave.core.store.adapter.statistics.FieldStatisticsType;
import org.locationtech.geowave.core.store.adapter.statistics.InternalDataStatistics;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;

public class FeatureBoundingBoxStatistics
extends BoundingBoxDataStatistics<SimpleFeature, FieldStatisticsQueryBuilder<Envelope>>
implements FieldNameStatistic {
    public static final FieldStatisticsType<Envelope> STATS_TYPE = new FieldStatisticsType("BOUNDING_BOX");
    private SimpleFeatureType reprojectedType;
    private MathTransform transform;

    public FeatureBoundingBoxStatistics() {
        super(STATS_TYPE);
    }

    public FeatureBoundingBoxStatistics(String fieldName) {
        this(null, fieldName);
    }

    public FeatureBoundingBoxStatistics(Short adapterId, String fieldName) {
        this(adapterId, fieldName, null, null);
    }

    public FeatureBoundingBoxStatistics(String fieldName, SimpleFeatureType reprojectedType, MathTransform transform) {
        this(null, fieldName, reprojectedType, transform);
    }

    public FeatureBoundingBoxStatistics(Short adapterId, String fieldName, SimpleFeatureType reprojectedType, MathTransform transform) {
        super(adapterId, STATS_TYPE, fieldName);
        this.reprojectedType = reprojectedType;
        this.transform = transform;
    }

    @Override
    public String getFieldName() {
        return this.extendedId;
    }

    @Override
    protected Envelope getEnvelope(SimpleFeature entry) {
        Geometry geometry;
        Object o = this.reprojectedType != null && this.transform != null && !this.reprojectedType.getCoordinateReferenceSystem().equals(entry.getType().getCoordinateReferenceSystem()) ? GeometryUtils.crsTransform(entry, this.reprojectedType, this.transform).getAttribute(this.getFieldName()) : entry.getAttribute(this.getFieldName());
        if (o != null && o instanceof Geometry && !(geometry = (Geometry)o).isEmpty()) {
            return geometry.getEnvelopeInternal();
        }
        return null;
    }

    public InternalDataStatistics<SimpleFeature, Envelope, FieldStatisticsQueryBuilder<Envelope>> duplicate() {
        return new FeatureBoundingBoxStatistics(this.adapterId, this.getFieldName(), this.reprojectedType, this.transform);
    }
}

