/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.query.aggregate.GeohashBinningStrategy;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.store.data.CommonIndexedPersistenceEncoding;
import org.locationtech.geowave.core.store.data.PersistentDataset;
import org.locationtech.geowave.core.store.index.CommonIndexValue;
import org.locationtech.jts.geom.Geometry;

public class GeohashCommonIndexedBinningStrategy
extends GeohashBinningStrategy<CommonIndexedPersistenceEncoding> {
    private String geometryFieldName;

    public GeohashCommonIndexedBinningStrategy() {
        this(2);
    }

    public GeohashCommonIndexedBinningStrategy(int precision) {
        this(precision, "default_geom_dimension");
    }

    public GeohashCommonIndexedBinningStrategy(int precision, String geometryFieldName) {
        super(precision);
        this.geometryFieldName = geometryFieldName;
    }

    @Override
    public Geometry getGeometry(CommonIndexedPersistenceEncoding entry) {
        PersistentDataset data = entry.getCommonData();
        CommonIndexValue geometryValue = (CommonIndexValue)data.getValue(this.geometryFieldName);
        if (geometryValue instanceof GeometryWrapper) {
            return ((GeometryWrapper)geometryValue).getGeometry();
        }
        return null;
    }

    @Override
    public byte[] toBinary() {
        byte[] fieldName = this.geometryFieldName.getBytes(StringUtils.getGeoWaveCharset());
        return ByteBuffer.allocate(8 + fieldName.length).putInt(this.getPrecision()).putInt(fieldName.length).put(fieldName).array();
    }

    @Override
    public void fromBinary(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.precision = bb.getInt();
        int fieldLen = bb.getInt();
        byte[] fieldBytes = new byte[fieldLen];
        bb.get(fieldBytes);
        this.geometryFieldName = new String(fieldBytes, StringUtils.getGeoWaveCharset());
    }
}

