/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query.aggregate;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.store.query.aggregate.AggregationBinningStrategy;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class GeohashBinningStrategy<T>
implements AggregationBinningStrategy<T> {
    protected int precision;

    public GeohashBinningStrategy(int precision) {
        this.precision = precision;
    }

    abstract Geometry getGeometry(T var1);

    protected static String encodeToGeohash(Geometry geo, int precision) {
        String GEOHASH_BASE_32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        Point centroid = geo.getCentroid();
        double latitude = centroid.getX();
        double longitude = centroid.getY();
        int idx = 0;
        int bit = 0;
        boolean evenBit = true;
        double latitudeMin = -90.0;
        double latitudeMax = 90.0;
        double longitudeMin = -180.0;
        double longitudeMax = 180.0;
        StringBuilder geohash = new StringBuilder(precision);
        while (geohash.length() < precision) {
            if (evenBit) {
                double currentLongitudeMid = (longitudeMin + longitudeMax) / 2.0;
                if (longitude >= currentLongitudeMid) {
                    idx = idx * 2 + 1;
                    longitudeMin = currentLongitudeMid;
                } else {
                    idx *= 2;
                    longitudeMax = currentLongitudeMid;
                }
            } else {
                double currentLatitudeMid = (latitudeMin + latitudeMax) / 2.0;
                if (latitude >= currentLatitudeMid) {
                    idx = idx * 2 + 1;
                    latitudeMin = currentLatitudeMid;
                } else {
                    idx *= 2;
                    latitudeMax = currentLatitudeMid;
                }
            }
            boolean bl = evenBit = !evenBit;
            if (++bit != 5) continue;
            geohash.append("0123456789bcdefghjkmnpqrstuvwxyz".charAt(idx));
            idx = 0;
            bit = 0;
        }
        return geohash.toString();
    }

    public int getPrecision() {
        return this.precision;
    }

    public String[] binEntry(T entry) {
        String[] stringArray;
        Geometry geometry = this.getGeometry(entry);
        if (geometry == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = GeohashBinningStrategy.encodeToGeohash(geometry, this.precision);
        }
        return stringArray;
    }

    public byte[] toBinary() {
        return ByteBuffer.allocate(4).putInt(this.precision).array();
    }

    public void fromBinary(byte[] bytes) {
        this.precision = ByteBuffer.wrap(bytes).getInt();
    }
}

