/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import java.net.MalformedURLException;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geowave.core.geotime.store.query.OptimalCQLQuery;
import org.locationtech.geowave.core.geotime.store.query.SpatialTemporalConstraintsBuilderImpl;
import org.locationtech.geowave.core.geotime.store.query.api.SpatialTemporalConstraintsBuilder;
import org.locationtech.geowave.core.geotime.store.query.api.VectorQueryConstraintsFactory;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraints;
import org.locationtech.geowave.core.store.query.constraints.QueryConstraintsFactoryImpl;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorQueryConstraintsFactoryImpl
extends QueryConstraintsFactoryImpl
implements VectorQueryConstraintsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptimalCQLQuery.class);
    public static final VectorQueryConstraintsFactoryImpl SINGLETON_INSTANCE = new VectorQueryConstraintsFactoryImpl();

    @Override
    public SpatialTemporalConstraintsBuilder spatialTemporalConstraints() {
        return new SpatialTemporalConstraintsBuilderImpl();
    }

    @Override
    public QueryConstraints cqlConstraints(String cqlExpression) {
        try {
            GeometryUtils.initClassLoader();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Unable to initialize GeoTools class loader", (Throwable)e);
        }
        try {
            Filter cqlFilter = ECQL.toFilter((String)cqlExpression);
            return new OptimalCQLQuery(cqlFilter);
        }
        catch (CQLException e) {
            LOGGER.error("Unable to parse CQL expresion", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryConstraints filterConstraints(Filter filter) {
        return new OptimalCQLQuery(filter);
    }
}

