/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.query;

import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.geotime.store.query.AbstractVectorConstraints;
import org.locationtech.geowave.core.geotime.store.query.ExplicitSpatialQuery;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.geotime.util.IndexOptimizationUtils;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialQuery
extends AbstractVectorConstraints<ExplicitSpatialQuery> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpatialQuery.class);

    public SpatialQuery() {
    }

    public SpatialQuery(ExplicitSpatialQuery delegateConstraints) {
        super(delegateConstraints);
    }

    @Override
    protected ExplicitSpatialQuery newConstraints() {
        return new ExplicitSpatialQuery();
    }

    @Override
    protected boolean isSupported(Index index, GeotoolsFeatureDataAdapter adapter) {
        return IndexOptimizationUtils.hasAtLeastSpatial(index);
    }

    @Override
    protected Filter getFilter(GeotoolsFeatureDataAdapter adapter) {
        return SpatialQuery.getFilter(adapter, (ExplicitSpatialQuery)this.delegateConstraints);
    }

    protected static Filter getFilter(GeotoolsFeatureDataAdapter adapter, ExplicitSpatialQuery delegateConstraints) {
        GeometryDescriptor geomDesc = adapter.getFeatureType().getGeometryDescriptor();
        CoordinateReferenceSystem adapterCrs = geomDesc.getCoordinateReferenceSystem();
        return GeometryUtils.geometryToSpatialOperator(SpatialQuery.transformToAdapter(adapterCrs, delegateConstraints), geomDesc.getLocalName(), adapterCrs == null ? GeometryUtils.getDefaultCRS() : adapterCrs);
    }

    private static Geometry transformToAdapter(CoordinateReferenceSystem adapterCrs, ExplicitSpatialQuery delegateConstraints) {
        Geometry queryGeometry = delegateConstraints.getQueryGeometry();
        if (adapterCrs == null) {
            return queryGeometry;
        }
        String indexCrsStr = GeometryUtils.getCrsCode(adapterCrs);
        if (indexCrsStr == null) {
            return queryGeometry;
        }
        if (GeometryUtils.crsMatches(delegateConstraints.getCrsCode(), indexCrsStr) || queryGeometry == null) {
            return queryGeometry;
        }
        CoordinateReferenceSystem crs = delegateConstraints.getCrs();
        if (crs == null) {
            String crsCode = delegateConstraints.getCrsCode();
            if (crsCode == null || crsCode.isEmpty()) {
                crsCode = "EPSG:4326";
            }
            try {
                crs = CRS.decode((String)crsCode, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.warn("Unable to decode spatial query crs", (Throwable)e);
            }
        }
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)adapterCrs, (boolean)true);
            return JTS.transform((Geometry)queryGeometry, (MathTransform)transform);
        }
        catch (FactoryException e) {
            LOGGER.warn("Unable to create coordinate reference system transform", (Throwable)e);
        }
        catch (MismatchedDimensionException | TransformException e) {
            LOGGER.warn("Unable to transform query geometry into index CRS", e);
        }
        return queryGeometry;
    }
}

