/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.jts.geom.Geometry;

public class GeometrySerializationProvider
implements FieldSerializationProviderSpi<Geometry> {
    public FieldReader<Geometry> getFieldReader() {
        return new GeometryReader();
    }

    public FieldWriter<Object, Geometry> getFieldWriter() {
        return new GeometryWriter();
    }

    protected static class GeometryWriter
    implements FieldWriter<Object, Geometry> {
        protected GeometryWriter() {
        }

        public byte[] writeField(Geometry fieldValue) {
            if (fieldValue == null) {
                return new byte[0];
            }
            return GeometryUtils.geometryToBinary(fieldValue, GeometryUtils.MAX_GEOMETRY_PRECISION);
        }
    }

    protected static class GeometryReader
    implements FieldReader<Geometry> {
        protected GeometryReader() {
        }

        public Geometry readField(byte[] fieldData) {
            if (fieldData == null || fieldData.length < 1) {
                return null;
            }
            return GeometryUtils.geometryFromBinary(fieldData, GeometryUtils.MAX_GEOMETRY_PRECISION, (byte)1);
        }

        public Geometry readField(byte[] fieldData, byte serializationVersion) {
            if (fieldData == null || fieldData.length < 1) {
                return null;
            }
            return GeometryUtils.geometryFromBinary(fieldData, GeometryUtils.MAX_GEOMETRY_PRECISION, serializationVersion);
        }
    }
}

