/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import java.nio.ByteBuffer;
import java.util.Date;
import org.locationtech.geowave.core.geotime.store.field.DateSerializationProvider;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.data.field.ArrayReader;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;

public class DateArraySerializationProvider
implements FieldSerializationProviderSpi<Date[]> {
    public FieldReader<Date[]> getFieldReader() {
        return new DateArrayReader();
    }

    public FieldWriter<Object, Date[]> getFieldWriter() {
        return new DateArrayWriter();
    }

    private static class DateArrayWriter
    implements FieldWriter<Object, Date[]> {
        private DateArrayWriter() {
        }

        public byte[] writeField(Date[] fieldValue) {
            if (fieldValue == null) {
                return new byte[0];
            }
            int bytes = VarintUtils.unsignedIntByteLength((int)fieldValue.length);
            for (Date value : fieldValue) {
                ++bytes;
                if (value == null) continue;
                bytes += VarintUtils.timeByteLength((long)value.getTime());
            }
            ByteBuffer buf = ByteBuffer.allocate(bytes);
            VarintUtils.writeUnsignedInt((int)fieldValue.length, (ByteBuffer)buf);
            for (Date value : fieldValue) {
                if (value == null) {
                    buf.put((byte)0);
                    continue;
                }
                buf.put((byte)1);
                VarintUtils.writeTime((long)value.getTime(), (ByteBuffer)buf);
            }
            return buf.array();
        }
    }

    private static class DateArrayReader
    implements FieldReader<Date[]> {
        private DateArrayReader() {
        }

        public Date[] readField(byte[] fieldData) {
            if (fieldData == null || fieldData.length == 0) {
                return null;
            }
            ByteBuffer buff = ByteBuffer.wrap(fieldData);
            int count = VarintUtils.readUnsignedInt((ByteBuffer)buff);
            ByteArrayUtils.verifyBufferSize((ByteBuffer)buff, (int)count);
            Date[] result = new Date[count];
            for (int i = 0; i < count; ++i) {
                result[i] = buff.get() > 0 ? new Date(VarintUtils.readTime((ByteBuffer)buff)) : null;
            }
            return result;
        }

        public Date[] readField(byte[] fieldData, byte serializationVersion) {
            if (serializationVersion < 1) {
                return (Date[])new ArrayReader((FieldReader)new DateSerializationProvider.DateReader()).readField(fieldData, serializationVersion);
            }
            return this.readField(fieldData);
        }
    }
}

