/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.field;

import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.locationtech.geowave.core.geotime.util.TimeUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldSerializationProviderSpi;
import org.locationtech.geowave.core.store.data.field.FieldWriter;

public class CalendarSerializationProvider
implements FieldSerializationProviderSpi<Calendar> {
    public FieldReader<Calendar> getFieldReader() {
        return new CalendarReader();
    }

    public FieldWriter<Object, Calendar> getFieldWriter() {
        return new CalendarWriter();
    }

    protected static class CalendarWriter
    implements FieldWriter<Object, Calendar> {
        protected CalendarWriter() {
        }

        public byte[] writeField(Calendar cal) {
            if (cal == null) {
                return new byte[0];
            }
            long time = TimeUtils.calendarToGMTMillis(cal);
            ByteBuffer buf = ByteBuffer.allocate(VarintUtils.timeByteLength((long)time));
            VarintUtils.writeTime((long)time, (ByteBuffer)buf);
            return buf.array();
        }
    }

    protected static class CalendarReader
    implements FieldReader<Calendar> {
        protected CalendarReader() {
        }

        public Calendar readField(byte[] fieldData) {
            if (fieldData == null || fieldData.length == 0) {
                return null;
            }
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.setTime(new Date(VarintUtils.readTime((ByteBuffer)ByteBuffer.wrap(fieldData))));
            return cal;
        }

        public Calendar readField(byte[] fieldData, byte serializationVersion) {
            if (fieldData == null || fieldData.length == 0) {
                return null;
            }
            if (serializationVersion < 1) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTime(new Date(ByteBuffer.wrap(fieldData).getLong()));
                return cal;
            }
            return this.readField(fieldData);
        }
    }
}

