/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.index.dimension.TemporalBinningStrategy;
import org.locationtech.geowave.core.geotime.index.dimension.TimeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.Time;
import org.locationtech.geowave.core.geotime.store.dimension.TimeReader;
import org.locationtech.geowave.core.geotime.store.dimension.TimeWriter;
import org.locationtech.geowave.core.index.ByteArrayUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.persist.PersistenceUtils;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.store.data.field.FieldReader;
import org.locationtech.geowave.core.store.data.field.FieldWriter;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexValue;

public class TimeField
implements NumericDimensionField<Time> {
    private static final String DEFAULT_FIELD_ID = "default_time_dimension";
    private NumericDimensionDefinition baseDefinition;
    private final TimeReader reader;
    private final TimeWriter writer;
    private String fieldName;

    public TimeField() {
        this.reader = new TimeReader();
        this.writer = new TimeWriter();
        this.fieldName = DEFAULT_FIELD_ID;
    }

    public TimeField(TemporalBinningStrategy.Unit timeUnit) {
        this(timeUnit, DEFAULT_FIELD_ID);
    }

    public TimeField(TemporalBinningStrategy.Unit timeUnit, String fieldName) {
        this((NumericDimensionDefinition)new TimeDefinition(timeUnit), fieldName);
    }

    public NumericData getFullRange() {
        return new NumericRange(0.0, (double)(System.currentTimeMillis() + 1L));
    }

    public TimeField(NumericDimensionDefinition baseDefinition, String fieldName) {
        this.baseDefinition = baseDefinition;
        this.reader = new TimeReader();
        this.writer = new TimeWriter();
        this.fieldName = fieldName;
    }

    public double normalize(double value) {
        return this.baseDefinition.normalize(value);
    }

    public double denormalize(double value) {
        return this.baseDefinition.denormalize(value);
    }

    public BinRange[] getNormalizedRanges(NumericData index) {
        return this.baseDefinition.getNormalizedRanges(index);
    }

    public NumericRange getDenormalizedRange(BinRange range) {
        return this.baseDefinition.getDenormalizedRange(range);
    }

    public int getFixedBinIdSize() {
        return this.baseDefinition.getFixedBinIdSize();
    }

    public double getRange() {
        return this.baseDefinition.getRange();
    }

    public NumericRange getBounds() {
        return this.baseDefinition.getBounds();
    }

    public NumericData getNumericData(Time dataElement) {
        return dataElement.toNumericData();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldWriter<?, Time> getWriter() {
        return this.writer;
    }

    public FieldReader<Time> getReader() {
        return this.reader;
    }

    public boolean isCompatibleWith(Class<? extends CommonIndexValue> clazz) {
        return Time.class.isAssignableFrom(clazz);
    }

    public NumericDimensionDefinition getBaseDefinition() {
        return this.baseDefinition;
    }

    public byte[] toBinary() {
        byte[] dimensionBinary = PersistenceUtils.toBinary((Persistable)this.baseDefinition);
        byte[] fieldNameBytes = StringUtils.stringToBinary((String)this.fieldName);
        ByteBuffer buf = ByteBuffer.allocate(dimensionBinary.length + fieldNameBytes.length + VarintUtils.unsignedIntByteLength((int)fieldNameBytes.length));
        VarintUtils.writeUnsignedInt((int)fieldNameBytes.length, (ByteBuffer)buf);
        buf.put(fieldNameBytes);
        buf.put(dimensionBinary);
        return buf.array();
    }

    public void fromBinary(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int fieldNameLength = VarintUtils.readUnsignedInt((ByteBuffer)buf);
        byte[] fieldNameBinary = ByteArrayUtils.safeRead((ByteBuffer)buf, (int)fieldNameLength);
        this.fieldName = StringUtils.stringFromBinary((byte[])fieldNameBinary);
        byte[] dimensionBinary = new byte[buf.remaining()];
        buf.get(dimensionBinary);
        this.baseDefinition = (NumericDimensionDefinition)PersistenceUtils.fromBinary((byte[])dimensionBinary);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseDefinition == null ? 0 : this.baseDefinition.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeField other = (TimeField)obj;
        if (this.baseDefinition == null ? other.baseDefinition != null : !this.baseDefinition.equals(other.baseDefinition)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }
}

