/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import java.nio.ByteBuffer;
import org.locationtech.geowave.core.geotime.store.dimension.TimeField;
import org.locationtech.geowave.core.index.VarintUtils;
import org.locationtech.geowave.core.index.persist.Persistable;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;
import org.locationtech.geowave.core.index.sfc.data.NumericValue;
import org.locationtech.geowave.core.store.dimension.NumericDimensionField;
import org.locationtech.geowave.core.store.index.CommonIndexValue;

public interface Time
extends Persistable,
CommonIndexValue {
    public NumericData toNumericData();

    public static class Timestamp
    implements Time {
        private long time;
        private byte[] visibility;

        public Timestamp() {
        }

        public Timestamp(long time) {
            this.time = time;
        }

        public Timestamp(long time, byte[] visibility) {
            this.time = time;
            this.visibility = visibility;
        }

        public byte[] getVisibility() {
            return this.visibility;
        }

        public void setVisibility(byte[] visibility) {
            this.visibility = visibility;
        }

        @Override
        public NumericData toNumericData() {
            return new NumericValue((double)this.time);
        }

        public byte[] toBinary() {
            ByteBuffer bytes = ByteBuffer.allocate(VarintUtils.timeByteLength((long)this.time));
            VarintUtils.writeTime((long)this.time, (ByteBuffer)bytes);
            return bytes.array();
        }

        public void fromBinary(byte[] bytes) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            this.time = VarintUtils.readTime((ByteBuffer)buf);
        }

        public boolean overlaps(NumericDimensionField[] field, NumericData[] rangeData) {
            assert (field[0] instanceof TimeField);
            return (long)Math.floor(rangeData[0].getMin()) <= this.time && (long)Math.ceil(rangeData[0].getMax()) >= this.time;
        }
    }

    public static class TimeRange
    implements Time {
        private long startTime;
        private long endTime;
        private byte[] visibility;

        public TimeRange() {
        }

        public TimeRange(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public TimeRange(long startTime, long endTime, byte[] visibility) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.visibility = visibility;
        }

        public byte[] getVisibility() {
            return this.visibility;
        }

        public void setVisibility(byte[] visibility) {
            this.visibility = visibility;
        }

        @Override
        public NumericData toNumericData() {
            return new NumericRange((double)this.startTime, (double)this.endTime);
        }

        public byte[] toBinary() {
            ByteBuffer bytes = ByteBuffer.allocate(VarintUtils.timeByteLength((long)this.startTime) + VarintUtils.timeByteLength((long)this.endTime));
            VarintUtils.writeTime((long)this.startTime, (ByteBuffer)bytes);
            VarintUtils.writeTime((long)this.endTime, (ByteBuffer)bytes);
            return bytes.array();
        }

        public void fromBinary(byte[] bytes) {
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            this.startTime = VarintUtils.readTime((ByteBuffer)buf);
            this.endTime = VarintUtils.readTime((ByteBuffer)buf);
        }

        public boolean overlaps(NumericDimensionField[] field, NumericData[] rangeData) {
            long t1;
            assert (field[0] instanceof TimeField);
            long t0 = (long)Math.ceil(rangeData[0].getMax()) - this.startTime;
            return Math.abs(t0 - (t1 = this.endTime - (long)Math.floor(rangeData[0].getMin()))) <= t0 + t1;
        }
    }
}

