/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.geotime.store.dimension;

import javax.annotation.Nullable;
import org.locationtech.geowave.core.geotime.index.dimension.LatitudeDefinition;
import org.locationtech.geowave.core.geotime.store.dimension.GeometryWrapper;
import org.locationtech.geowave.core.geotime.store.dimension.SpatialField;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.dimension.NumericDimensionDefinition;
import org.locationtech.geowave.core.index.sfc.data.NumericData;

public class LatitudeField
extends SpatialField {
    public LatitudeField() {
    }

    public LatitudeField(@Nullable Integer geometryPrecision) {
        this(geometryPrecision, "default_geom_dimension");
    }

    public LatitudeField(@Nullable Integer geometryPrecision, boolean useHalfRange) {
        this(geometryPrecision, useHalfRange, "default_geom_dimension");
    }

    public LatitudeField(@Nullable Integer geometryPrecision, String fieldName) {
        this(geometryPrecision, false, fieldName);
    }

    public LatitudeField(@Nullable Integer geometryPrecision, boolean useHalfRange, String fieldName) {
        this((NumericDimensionDefinition)new LatitudeDefinition(useHalfRange), geometryPrecision, fieldName);
    }

    public LatitudeField(NumericDimensionDefinition baseDefinition, @Nullable Integer geometryPrecision, String fieldName) {
        super(baseDefinition, geometryPrecision, fieldName);
    }

    public NumericData getNumericData(GeometryWrapper geometry) {
        return GeometryUtils.yRangeFromGeometry(geometry.getGeometry());
    }
}

